<?php


namespace App\Service\SMSGateways;


use App\Entity\SMSGateways;
use App\Service\AppSettings;
use http\Env;
use Symfony\Component\HttpClient\CurlHttpClient;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

class CreativeONSMS extends SMSGateWayInterface
{

    /*
     * Default values to test message
     * */

//$query = array(
//'id' => 'creative',
//'pass' => 'Farash..99,',
//'mask' => 'CreativeOn',
//'to' => '923167852626',
//'msg' => 'test message from fekara',
//'lang' => 'English',
//'type' => 1,
//);

    /**
     * @inheritDoc
     * @throws TransportExceptionInterface
     */
    public function sendMessage(SMSGateways $SMSGateways, array $assets)
    {
        ## api key e.g account, auth token,
        $apiKey = $this->getApiKey($SMSGateways);
        ## Account id
        $accountId = $this->getAccountId($SMSGateways);
        ## get Mask
        $smsMask = $this->getSMSMask($SMSGateways);

        ## get end point where we want to send a request.
        $endPoint = $this->endPoints($SMSGateways);
        ## Phone number
        $phoneNumber = $this->validatePhoneNumber($assets['receiver']);
        ## message that you want to send
        $message = $this->validateMessage($assets['message'], $SMSGateways);

        if (!$apiKey || !$endPoint) {
            ## if some of them is empty..
            return 'Api Key or End points are missing';
        }

        if (!$phoneNumber || !$message) {
            ## if number or messages are not validate
            return 'receiver or message is missing';
        }

        ## end point to send the message from system..
        //  return $endPoint = $endPoint.'?api='.$apiKey.'&to='.$phoneNumber.'&message='.$message;

        ## logging
        $this->logging($message, $phoneNumber);

        ## if debug don't send message.
//        if (getenv('debug', false)) {
//            return false;
//        }

        $query = array(
            'id' => $accountId,
            'pass' => $apiKey,
            'mask' => $smsMask,
            'to' => $phoneNumber,
            'msg' => $message,
            'lang' => 'English',
            'type' => 1,
        );
        $client = HttpClient::create();
        $response = $client->request(
            'GET',
            $endPoint,
            [
                'query' => $query,
            ]
        );


        try {
            $response = $response->getContent();

        } catch (ClientExceptionInterface $e) {
        } catch (RedirectionExceptionInterface $e) {
        } catch (ServerExceptionInterface $e) {
        } catch (TransportExceptionInterface $e) {
            $response = $e->getMessage();
        }

        return $response;
    }



    /**
     * @inheritDoc
     */
    //	public function getApiKey( SMSGateways $SMSGateways ) {
    //		return trim( $SMSGateways->getSmsGwAuthorToken() );
    //	}


    //	public function endPoints( SMSGateways $SMSGateways ) {
    //		return trim( $SMSGateways->getEndPoint() );
    //	}
}
