<?php

namespace App\Repository;

use App\Entity\ClassSessionEnrolmentSubjects;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\Query;
use Doctrine\ORM\QueryBuilder;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method ClassSessionEnrolmentSubjects|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassSessionEnrolmentSubjects|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassSessionEnrolmentSubjects[]    findAll()
 * @method ClassSessionEnrolmentSubjects[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 *
 */
class ClassSessionEnrolmentSubjectsRepository extends ServiceEntityRepository
{

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassSessionEnrolmentSubjects::class);
    }

    ## get enrolled students on based of subject id.
    public function get__EnrolledStudentList($subjectID)
    {
        return $this->createQueryBuilder('class_session_enrolment_subjects')
            ->leftJoin('class_session_enrolment_subjects.class_session_entrolment', 'class_session_entrolment')
            ->addSelect('class_session_entrolment')
            ->leftJoin('class_session_entrolment.user_id', 'userId')
            ->addSelect('userId')
            ->andWhere('class_session_enrolment_subjects.classSubject = :id')
            ->setParameter('id', $subjectID)
            ->getQuery()
            ->getResult();
    }


    public function get__EnrolledStudentList__Logic(QueryBuilder $query_builder, $subjectID): QueryBuilder
    {
        return $query_builder->leftJoin('class_session_enrolment_subjects.class_session_entrolment', 'class_session_entrolment')
            ->addSelect('class_session_entrolment')
            ->leftJoin('class_session_entrolment.user_id', 'userId')
            ->addSelect('userId')
            ->andWhere('class_session_enrolment_subjects.classSubject = :id')
            ->setParameter('id', $subjectID);

    }

    ## search
    public function searchInClassSessionEnrolmentSubject(ParameterBag $bag)
    {
        $queryBuilder = $this->createQueryBuilder('class_session_subject');
        if (!empty($bag->get('classRef'))) {
            $queryBuilder->andWhere('class_session_subject');
        }
    }

}
