<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Translatable\Translatable;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ShortEmailTemplatesRepository")
 */
class ShortEmailTemplates implements Translatable
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\OneToOne(targetEntity="App\Entity\EmailTemplates", inversedBy="shortEmailTemplates", cascade={"persist", "remove"})
     * @ORM\JoinColumn(nullable=false)
     */
    private $email_template_refer;

    /**
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;

    /**
     * @Gedmo\Translatable()
     * @ORM\Column(type="text")
     */
    private $content;

    /**
     * @ORM\Column(type="array", nullable=true)
     */
    private $variables = [];

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_active;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ScheduleMessage", mappedBy="short_template")
     */
    private $scheduleMessages;

    public function __construct()
    {
        $this->scheduleMessages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmailTemplateRefer(): ?EmailTemplates
    {
        return $this->email_template_refer;
    }

    public function setEmailTemplateRefer(EmailTemplates $email_template_refer): self
    {
        $this->email_template_refer = $email_template_refer;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeInterface $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(\DateTimeInterface $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getContent(): ?string
    {
        return $this->content;
    }

    public function setContent(string $content): self
    {
        $this->content = $content;

        return $this;
    }

    public function getVariables(): ?array
    {
        return $this->variables;
    }

    public function setVariables(?array $variables): self
    {
        $this->variables = $variables;

        return $this;
    }

    public function getIsActive(): ?bool
    {
        return $this->is_active;
    }

    public function setIsActive(bool $is_active): self
    {
        $this->is_active = $is_active;

        return $this;
    }

    /**
     * @return Collection|ScheduleMessage[]
     */
    public function getScheduleMessages(): Collection
    {
        return $this->scheduleMessages;
    }

    public function addScheduleMessage(ScheduleMessage $scheduleMessage): self
    {
        if (!$this->scheduleMessages->contains($scheduleMessage)) {
            $this->scheduleMessages[] = $scheduleMessage;
            $scheduleMessage->setShortTemplate($this);
        }

        return $this;
    }

    public function removeScheduleMessage(ScheduleMessage $scheduleMessage): self
    {
        if ($this->scheduleMessages->contains($scheduleMessage)) {
            $this->scheduleMessages->removeElement($scheduleMessage);
            // set the owning side to null (unless already changed)
            if ($scheduleMessage->getShortTemplate() === $this) {
                $scheduleMessage->setShortTemplate(null);
            }
        }

        return $this;
    }
}
