<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Timestampable\Traits\Timestampable;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassTimeTableSegmentsRepository")
 */
class ClassTimeTableSegments
{
    use Timestampable;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassTimeTable", inversedBy="classTimeTableSegments")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank()
     */
    private $class_time_table;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="classTimeTableSegments")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank()
     */
    private $class;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="classTimeTableSegments")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank()
     */
    private $class_subject;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="classTimeTableSegments")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank()
     */
    private $teacher;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="classTimeTableAllocatedTeacherTwo")
     */
    private $teacher_backup;

    /**
     * @ORM\Column(type="string", length=100)
     * @Assert\NotBlank()
     * @Assert\Length(max=100, maxMessage="Lecture name can't be more than 100 characters")
     */
    private $lecture_name;

    /**
     * @ORM\Column(type="integer")
     * @Assert\NotBlank()
     */
    private $lecture_duration;

    /**
     * @ORM\Column(type="time")
     * @Assert\NotBlank()
     * @Assert\Time()
     */
    private $lecture_start_time;

    /**
     * @ORM\Column(type="time")
     * @Assert\NotBlank()
     * @Assert\Time()
     */
    private $lecture_end_time;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Assert\Length(max=255, maxMessage="Lecture name can't be more than 255 characters")
     */
    private $lecture_description;

    /**
     * @ORM\Column(type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    private $created_at;

    /**
     * @ORM\Column(type="datetime")
     * @Gedmo\Timestampable(on="update")
     */
    private $updated_at;

    /**
     * @ORM\Column(type="smallint")
     */
    private $lecture_day;

    /**
     * @ORM\Column(type="date")
     */
    private $lecture_date;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $meeting_link;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getClassTimeTable(): ?ClassTimeTable
    {
        return $this->class_time_table;
    }

    public function setClassTimeTable(?ClassTimeTable $class_time_table): self
    {
        $this->class_time_table = $class_time_table;

        return $this;
    }

    public function getClass(): ?Classes
    {
        return $this->class;
    }

    public function setClass(?Classes $class): self
    {
        $this->class = $class;

        return $this;
    }

    public function getClassSubject(): ?ClassSubject
    {
        return $this->class_subject;
    }

    public function setClassSubject(?ClassSubject $class_subject): self
    {
        $this->class_subject = $class_subject;

        return $this;
    }

    public function getTeacher(): ?User
    {
        return $this->teacher;
    }

    public function setTeacher(?User $teacher): self
    {
        $this->teacher = $teacher;

        return $this;
    }

    public function getTeacherBackup(): ?User
    {
        return $this->teacher_backup;
    }

    public function setTeacherBackup(?User $teacher_backup): self
    {
        $this->teacher_backup = $teacher_backup;

        return $this;
    }

    public function getLectureName(): ?string
    {
        return $this->lecture_name;
    }

    public function setLectureName(string $lecture_name): self
    {
        $this->lecture_name = $lecture_name;

        return $this;
    }

    public function getLectureDuration(): ?int
    {
        return $this->lecture_duration;
    }

    public function setLectureDuration($lecture_duration): self
    {
        $this->lecture_duration = $lecture_duration;

        return $this;
    }

    public function getLectureStartTime()
    {
        return $this->lecture_start_time;
    }

    public function setLectureStartTime(\DateTimeInterface $lecture_start_time): self
    {
        $this->lecture_start_time = $lecture_start_time;

        return $this;
    }

    public function getLectureEndTime(): ?\DateTimeInterface
    {
        return $this->lecture_end_time;
    }

    public function setLectureEndTime(\DateTimeInterface $lecture_end_time): self
    {
        $this->lecture_end_time = $lecture_end_time;

        return $this;
    }

    public function getLectureDescription(): ?string
    {
        return $this->lecture_description;
    }

    public function setLectureDescription(?string $lecture_description): self
    {
        $this->lecture_description = $lecture_description;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->created_at;
    }

    public function setCreatedAt(\DateTimeInterface $created_at): self
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updated_at;
    }

    public function setUpdatedAt(\DateTimeInterface $updated_at): self
    {
        $this->updated_at = $updated_at;

        return $this;
    }

    public function getLectureDay(): ?int
    {
        return $this->lecture_day;
    }

    public function setLectureDay(int $lecture_day): self
    {
        $this->lecture_day = $lecture_day;

        return $this;
    }

    public function getLectureDate(): ?\DateTimeInterface
    {
        return $this->lecture_date;
    }

    public function setLectureDate(\DateTimeInterface $lecture_date): self
    {
        $this->lecture_date = $lecture_date;

        return $this;
    }

    public function getMeetingLink(): ?string
    {
        return $this->meeting_link;
    }

    public function setMeetingLink(?string $meeting_link): self
    {
        $this->meeting_link = $meeting_link;

        return $this;
    }
}
