<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\AccountsRepository")
 */
class Accounts {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=60)
	 */
	private $acc_name;

	/**
	 * @ORM\Column(type="smallint")
	 */
	private $acc_type;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $acc_is_online;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $acc_descrption;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $acc_is_default;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\Transactions", mappedBy="accounts_reference")
	 */
	private $transactions;

	public function __construct() {
		$this->transactions = new ArrayCollection();
	}

	public function getId(): ?int {
		return $this->id;
	}

	public function getAccName(): ?string {
		return $this->acc_name;
	}

	public function setAccName( string $acc_name ): self {
		$this->acc_name = $acc_name;

		return $this;
	}

	public function getAccType(): ?int {
		return $this->acc_type;
	}

	public function setAccType( int $acc_type ): self {
		$this->acc_type = $acc_type;

		return $this;
	}

	public function getAccIsOnline(): ?bool {
		return $this->acc_is_online;
	}

	public function setAccIsOnline( bool $acc_is_onloine ): self {
		$this->acc_is_online = $acc_is_onloine;

		return $this;
	}

	public function getAccDescrption(): ?string {
		return $this->acc_descrption;
	}

	public function setAccDescrption( ?string $acc_descrption ): self {
		$this->acc_descrption = $acc_descrption;

		return $this;
	}

	public function getAccIsDefault(): ?bool {
		return $this->acc_is_default;
	}

	public function setAccIsDefault( bool $acc_is_default ): self {
		$this->acc_is_default = $acc_is_default;

		return $this;
	}

	/**
	 * @return Collection|Transactions[]
	 */
	public function getTransactions(): Collection {
		return $this->transactions;
	}

	public function addTransaction( Transactions $transaction ): self {
		if ( ! $this->transactions->contains( $transaction ) ) {
			$this->transactions[] = $transaction;
			$transaction->setAccountsReference( $this );
		}

		return $this;
	}

	public function removeTransaction( Transactions $transaction ): self {
		if ( $this->transactions->contains( $transaction ) ) {
			$this->transactions->removeElement( $transaction );
			// set the owning side to null (unless already changed)
			if ( $transaction->getAccountsReference() === $this ) {
				$transaction->setAccountsReference( null );
			}
		}

		return $this;
	}
}
