<?php


namespace App\Service\Mics\Import;


use App\Service\DefaultFunction;
use App\Service\FileManagment;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Serializer\Encoder\CsvEncoder;

class ImportBasicSettings
{


    /**
     * @var EntityManagerInterface
     */
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     * @param Request $request
     * @param FileManagment $fileManagement
     * @return array|mixed|string|null
     * @Purpose: Upload file before convert CSV file content to Array.
     */
    public function doUploadCSVFile(Request $request, FileManagment $fileManagement)
    {
        $uploadedFile = $request->files;
        /** @var UploadedFile $uploadedFileArray */
        $uploadedFileArray = $uploadedFile->get('fileUploadToImport');

        if (empty($uploadedFileArray)) {
            return null;
        }

        if (empty($uploadedFileArray) && $uploadedFileArray->getClientOriginalExtension() == 'csv') {
            ## if empty file array.
            return 'File not exits & invalid file extension';
        }

        $tempAr = [
            'fileArray' => $uploadedFileArray,
            'path' => 'importingDataFileStorage',
            'returnPath' => true,
        ];
        $fileUploadResponse = $fileManagement->uploadFile($tempAr);

        if (!empty($fileUploadResponse) && !empty($fileUploadResponse['response']) && $fileUploadResponse['response'] == 'OK' && !empty($fileUploadResponse['extra_data'])) {
            $decodedData = $this->convertCsvFileToArray($fileUploadResponse['extra_data']);
        } else {
            $decodedData = null;
        }

        return $decodedData;
    }

    /**
     * @param $filePath
     * @return array|mixed
     * @purpose: Convert CSV file content to Array.
     */
    public function convertCsvFileToArray($filePath)
    {
        $contentOfFile = file_get_contents($filePath);

        $contentOfFile = mb_convert_encoding(
            $contentOfFile,
            'UTF-8',
            mb_detect_encoding($contentOfFile, 'UTF-8, ISO-8859-1', true)
        );
        $encoders = new CsvEncoder();

        return $encoders->decode($contentOfFile, 'csv');
    }

    /**
     * @param Request $request
     * @param FileManagment $fileManagement
     * @purpose: Get CSV File Content
     * @return array|mixed|string|null
     */
    public function getCSVFileDataIntoArray(Request $request, FileManagment $fileManagement)
    {
        return $this->doUploadCSVFile($request, $fileManagement);
    }

}