<?php

namespace App\Repository;

use App\Entity\VirtualClassRoom;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method VirtualClassRoom|null find($id, $lockMode = null, $lockVersion = null)
 * @method VirtualClassRoom|null findOneBy(array $criteria, array $orderBy = null)
 * @method VirtualClassRoom[]    findAll()
 * @method VirtualClassRoom[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class VirtualClassRoomRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, VirtualClassRoom::class);
    }

    ## get Virtual Class Room
    public function getVirtualClassRooms(array $classesArray)
    {
        $qb = $this->createQueryBuilder('virtual_class_room');
        $qb->add('where', $qb->expr()->in('virtual_class_room.classes', $classesArray));
        return $qb->getQuery()->getResult();
    }
}
