<?php

namespace App\Repository;

use App\Entity\AppSettings;
use App\Service\FileManagment;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\DBAL\DBALException;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method AppSettings|null find( $id, $lockMode = null, $lockVersion = null )
 * @method AppSettings|null findOneBy( array $criteria, array $orderBy = null )
 * @method AppSettings[]    findAll()
 * @method AppSettings[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class AppSettingsRepository extends ServiceEntityRepository {

	/**
	 * @var RegistryInterface
	 */
	private $registry;
	/**
	 * @var FileManagment
	 */
	private $fileManagment;

	public function __construct( RegistryInterface $registry, FileManagment $fileManagment ) {
		parent::__construct( $registry, AppSettings::class );
		$this->registry      = $registry;
		$this->fileManagment = $fileManagment;
	}

	/**
	 * PURPOSE: Get the result in the array format & place array value as a array index when retrieving data from
	 * database.
	 *
	 * @return array
	 */
	public function InArray() {

		try {
			$response = $this->createQueryBuilder( 'app_settings' )
			                 ->indexBy( 'app_settings', 'app_settings.name' )
			                 ->getQuery()
			                 ->getArrayResult();
		} catch ( \Exception $exception ) {
			$response = $exception->getMessage();
		}

		return $response;

	}

	/**
	 * @return mixed[]|string|null
	 *  PURPOSE : Add basic data to the fekara table.
	 */
	public function insertBasicData() {
		$response      = null;
		$ar            = [
			'projectPath'    => true,
			'path'           => 'installAssets',
			'getFileContent' => true,
		];
		$insertCommand = $this->fileManagment->getUploadedFile( $ar );
		if ( ! empty( $insertCommand[0] ) ) {
			$connection = $this->getEntityManager()->getConnection();
			try {
				$statement = $connection->prepare( (string) $insertCommand[0] );
				$statement->execute();
				$response = 'OK';
			} catch ( DBALException $e ) {
				$response = $e->getMessage();
			}
		}

		return $response;
	}

}
