<?php

namespace App\Repository;

use App\Entity\AAnswerRegardingCF;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method AAnswerRegardingCF|null find( $id, $lockMode = null, $lockVersion = null )
 * @method AAnswerRegardingCF|null findOneBy( array $criteria, array $orderBy = null )
 * @method AAnswerRegardingCF[]    findAll()
 * @method AAnswerRegardingCF[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class AAnswerRegardingCFRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, AAnswerRegardingCF::class );
	}

	/**
	 * @param $fieldId
	 * @param $userId
	 *
	 * This method is used to get the specific field answer based on the speciftc user.
	 *
	 * @return mixed
	 */
	public function getTheFieldAnswer( $fieldId, $userId ) {

		try {
			return $this->createQueryBuilder( 'answer' )
			            ->leftJoin( 'answer.CustomFields', 'custom_fields' )
			            ->leftJoin( 'answer.User', 'user' )
			            ->andWhere( 'user.id = :userId' )
			            ->andWhere( 'custom_fields.id = :fieldId' )
			            ->setParameter( 'fieldId', $fieldId )
			            ->setParameter( 'userId', $userId )
			            ->getQuery()
			            ->getSingleResult();
		} catch ( \Exception $exception ) {
			return $exception->getMessage();
		}
	}

	// /**
	//  * @return AAnswerRegardingCF[] Returns an array of AAnswerRegardingCF objects
	//  */
	/*
	public function findByExampleField($value)
	{
		return $this->createQueryBuilder('a')
			->andWhere('a.exampleField = :val')
			->setParameter('val', $value)
			->orderBy('a.id', 'ASC')
			->setMaxResults(10)
			->getQuery()
			->getResult()
		;
	}
	*/

	/*
	public function findOneBySomeField($value): ?AAnswerRegardingCF
	{
		return $this->createQueryBuilder('a')
			->andWhere('a.exampleField = :val')
			->setParameter('val', $value)
			->getQuery()
			->getOneOrNullResult()
		;
	}
	*/
}
