<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200408100351 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() !== 'mysql',
            'Migration can only be executed safely on \'mysql\'.'
        );

        $this->addSql(
            'CREATE TABLE class_time_table (id INT AUTO_INCREMENT NOT NULL, class_ownership_id INT DEFAULT NULL, class_ownership_two_id INT DEFAULT NULL, class_id INT NOT NULL, start_time TIME NOT NULL, end_time TIME NOT NULL, break_mints TIME DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX IDX_5569C98511D01F6 (class_ownership_id), INDEX IDX_5569C982C6F64E (class_ownership_two_id), INDEX IDX_5569C98EA000B10 (class_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'CREATE TABLE class_time_table_segments (id INT AUTO_INCREMENT NOT NULL, class_time_table_id INT NOT NULL, class_id INT NOT NULL, class_subject_id INT NOT NULL, teacher_id INT NOT NULL, teacher_backup_id INT DEFAULT NULL, lecture_name VARCHAR(100) NOT NULL, lecture_duration TIME NOT NULL, lecture_start_time TIME NOT NULL, lecture_end_time TIME NOT NULL, lecture_description VARCHAR(255) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX IDX_11A492EFCABD1DAA (class_time_table_id), INDEX IDX_11A492EFEA000B10 (class_id), INDEX IDX_11A492EFB4332E25 (class_subject_id), INDEX IDX_11A492EF41807E1D (teacher_id), INDEX IDX_11A492EFE9D62B52 (teacher_backup_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB'
        );
        $this->addSql(
            'ALTER TABLE class_time_table ADD CONSTRAINT FK_5569C98511D01F6 FOREIGN KEY (class_ownership_id) REFERENCES user (id)'
        );
        $this->addSql(
            'ALTER TABLE class_time_table ADD CONSTRAINT FK_5569C982C6F64E FOREIGN KEY (class_ownership_two_id) REFERENCES user (id)'
        );
        $this->addSql(
            'ALTER TABLE class_time_table ADD CONSTRAINT FK_5569C98EA000B10 FOREIGN KEY (class_id) REFERENCES classes (id)'
        );
        $this->addSql(
            'ALTER TABLE class_time_table_segments ADD CONSTRAINT FK_11A492EFCABD1DAA FOREIGN KEY (class_time_table_id) REFERENCES class_time_table (id)'
        );
        $this->addSql(
            'ALTER TABLE class_time_table_segments ADD CONSTRAINT FK_11A492EFEA000B10 FOREIGN KEY (class_id) REFERENCES classes (id)'
        );
        $this->addSql(
            'ALTER TABLE class_time_table_segments ADD CONSTRAINT FK_11A492EFB4332E25 FOREIGN KEY (class_subject_id) REFERENCES class_subject (id)'
        );
        $this->addSql(
            'ALTER TABLE class_time_table_segments ADD CONSTRAINT FK_11A492EF41807E1D FOREIGN KEY (teacher_id) REFERENCES user (id)'
        );
        $this->addSql(
            'ALTER TABLE class_time_table_segments ADD CONSTRAINT FK_11A492EFE9D62B52 FOREIGN KEY (teacher_backup_id) REFERENCES user (id)'
        );
        $this->addSql(
            'ALTER TABLE class_subject ADD CONSTRAINT FK_3EBB598623EDC87 FOREIGN KEY (subject_id) REFERENCES subjects (id)'
        );
        $this->addSql('CREATE INDEX IDX_3EBB598623EDC87 ON class_subject (subject_id)');
        $this->addSql('ALTER TABLE user CHANGE roles roles JSON NOT NULL');
        $this->addSql('ALTER TABLE class_fee_schedule RENAME INDEX fk_f78441aab4332e25 TO IDX_F78441AAB4332E25');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() !== 'mysql',
            'Migration can only be executed safely on \'mysql\'.'
        );

        $this->addSql('ALTER TABLE class_time_table_segments DROP FOREIGN KEY FK_11A492EFCABD1DAA');
        $this->addSql('DROP TABLE class_time_table');
        $this->addSql('DROP TABLE class_time_table_segments');
        $this->addSql('ALTER TABLE class_fee_schedule RENAME INDEX idx_f78441aab4332e25 TO FK_F78441AAB4332E25');
        $this->addSql('ALTER TABLE class_subject DROP FOREIGN KEY FK_3EBB598623EDC87');
        $this->addSql('DROP INDEX IDX_3EBB598623EDC87 ON class_subject');
        $this->addSql('ALTER TABLE user CHANGE roles roles LONGTEXT NOT NULL COLLATE utf8mb4_bin');
    }
}
