<?php

/**
 * when data save in it: when we are attaching fee with the class the attached fee saves in this table,
 *
 * */


namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassFeeTemplateRepository")
 */
class ClassFeeTemplate
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $amount;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\StudentFee", inversedBy="classFeeTemplates")
     * @ORM\JoinColumn(nullable=false)
     */
    private $fee;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassTemplate", inversedBy="classFeeTemplates")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class_template;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFee", mappedBy="class_fee_template")
     */
    private $classFees;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->classFees = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getFee(): ?StudentFee
    {
        return $this->fee;
    }

    public function setFee(?StudentFee $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    public function getClassTemplate(): ?ClassTemplate
    {
        return $this->class_template;
    }

    public function setClassTemplate(?ClassTemplate $class_template): self
    {
        $this->class_template = $class_template;

        return $this;
    }

    /**
     * @return Collection|ClassFee[]
     */
    public function getClassFees(): Collection
    {
        return $this->classFees;
    }

    public function addClassFee(ClassFee $classFee): self
    {
        if (!$this->classFees->contains($classFee)) {
            $this->classFees[] = $classFee;
            $classFee->setClassFeeTemplate($this);
        }

        return $this;
    }

    public function removeClassFee(ClassFee $classFee): self
    {
        if ($this->classFees->contains($classFee)) {
            $this->classFees->removeElement($classFee);
            // set the owning side to null (unless already changed)
            if ($classFee->getClassFeeTemplate() === $this) {
                $classFee->setClassFeeTemplate(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
