<?php

namespace App\Controller;

use App\Entity\AppSettings;
use App\Entity\ClassTimeTable;
use App\Entity\ClassTimeTableSegments;
use App\Repository\ClassTimeTableRepository;
use App\Repository\UserRepository;
use App\Service\DefaultFunction;
use App\Service\StudentClasses;
use App\Service\SubjectService;
use App\Service\TriggerNotifications;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query\Parameter;
use http\Env\Request;
use Knp\Snappy\Pdf;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Response as ResponseAlias;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * */
class ClassTimeTableController extends AbstractController
{

    /**
     * @var EntityManager
     */
    private $entityManager;
    /**
     * @var Pdf
     */
    private $pdf;

    public function __construct(EntityManagerInterface $entityManager, Pdf $pdf)
    {
        $this->entityManager = $entityManager;
        $this->pdf = $pdf;
    }

    /**
     * @Route("/class/ownership/{id}", name="class_owner_ship", defaults={"id"=null})
     * @param UserRepository $userRepository
     * @param \Symfony\Component\HttpFoundation\Request $request
     * @param DefaultFunction $defaultFunction
     * @param null $id
     * @return Response
     */
    public function index(
        UserRepository $userRepository,
        \Symfony\Component\HttpFoundation\Request $request,
        DefaultFunction $defaultFunction,
        $id = null
    ) {

        ## when s
        if ($request->isMethod('POST')) {
            try {


                if (empty($request->request->get('class'))) {
                    $this->addFlash('classOwnerShipFlashError', 'Please Select Class');

                    return $this->redirectToRoute('class_owner_ship');
                } else {

                    /** @var ClassTimeTable $classOwnershipFound */
                    $classOwnershipFound = $this->entityManager->getRepository('App:ClassTimeTable')->findOneBy(
                        [
                            'class' => $request->request->get('class'),
                        ]
                    );

                    if ($classOwnershipFound) {
                        $this->addFlash(
                            'classOwnerShipFlashError',
                            'Same Class has already have a Ownership of Teacher,  '.$classOwnershipFound->getClassOwnership(
                            )->getFullName().' , so Edit that Class to Change Ownership or Change Start and End Time'
                        );

                        return $this->redirectToRoute('class_owner_ship');
                    }
                }

                $request->request->get('class');


                $ClassTimeTable = null;

                ## if request to edit an existing record
                if (!empty($request->request->get('id'))) {
                    $ClassTimeTable = $this->entityManager->getRepository('App:ClassTimeTable')->find(
                        $request->request->get('id')
                    );
                }


                ## if classTimeTable is not initiate then create san object.
                if (!$ClassTimeTable instanceof ClassTimeTable) {
                    $ClassTimeTable = new ClassTimeTable();
                }

                ## set Class
                $ClassTimeTable->setClass(
                    $this->entityManager->getRepository('App:Classes')->find($request->request->get('class'))
                );

                ## set Class Start Time
                $ClassTimeTable->setStartTime(
                    $defaultFunction->convert_datetimeStringIntoObject($request->request->get('start_time'))
                );

                ## set class end time
                $ClassTimeTable->setEndTime(
                    $defaultFunction->convert_datetimeStringIntoObject($request->request->get('end_time'))
                );

                ## set break mints
                $ClassTimeTable->setBreakMints(
                    $defaultFunction->convert_datetimeStringIntoObject($request->request->get('break_mints'))
                );

                ## set teachers ownership.
                if (!empty($request->request->get('owners')[0])) {
                    $ClassTimeTable->setClassOwnership(
                        $this->entityManager->getRepository('App:User')->find($request->request->get('owners')[0])
                    );
                }


                ## set second teacher ownership.
                if (!empty($request->request->get('owners')[1])) {
                    $ClassTimeTable->setClassOwnershipTwo(
                        $this->entityManager->getRepository('App:User')->find($request->request->get('owners')[1])
                    );
                }

                $this->entityManager->persist($ClassTimeTable);

                $this->entityManager->flush();

                $this->addFlash('classOwnerShipFlashSuccess', 'Class OwnerShip has assigned to Teacher');
                // return $this->redirectToRoute('class_owner_ship_list');
            } catch (\Exception $exception) {
                $this->addFlash('classOwnerShipFlashError', $exception->getMessage());
            }
        }

        ##
        $classTimeTable = new ClassTimeTable();
        if ($id) {
            $classTimeTable = $this->entityManager->getRepository('App:ClassTimeTable')->find($id);
        }

        return $this->render(
            'class/ownership/class_ownership.html.twig',
            [
                'classTimeTable' => $classTimeTable,
                'active_classes' => $this->entityManager->getRepository('App:Classes')->getActiveClassesOfActiveSession(
                    false
                ),
                'teachers' => $userRepository->findBy(
                    ['category' => TeacherController::userCategory, 'is_active' => 1, 'is_deleted' => 0],
                    ['id' => 'DESC']
                ),
            ]
        );
    }


    /**
     * @Route("/class/owner-ship", name="class_owner_ship_list")
     * @return Response
     */
    public function list_of_ClassOwnerShip()
    {
        return $this->render(
            'class/ownership/class_ownership_list.html.twig',
            [
                'classOwnerShips' => $this->entityManager->getRepository('App:ClassTimeTable')->findAll(),
            ]
        );
    }

    /**
     * @Route("/subject/owner-ship/{class_owner_ship_id}/{class_id}", name="subject_ownership", defaults={"class_owner_ship_id":null, "class_id":null})
     * @param SubjectService $subjectService
     * @param int $class_id
     * @param $class_owner_ship_id
     * @param \Symfony\Component\HttpFoundation\Request $request
     * @param DefaultFunction $defaultFunction
     * @return Response
     */
    public function assign_teachers_to_class_lecture(
        SubjectService $subjectService,
        int $class_id,
        $class_owner_ship_id,
        \Symfony\Component\HttpFoundation\Request $request,
        DefaultFunction $defaultFunction
    ) {


        $isNewlyAdded = true;
        if ($request->isMethod('POST')) {
            $weekDaysArray = [
                1 => 'Sunday',
                2 => 'Monday',
                3 => 'Tuesday',
                4 => 'Wednesday',
                5 => 'Thursday',
                6 => 'Friday',
                7 => 'Saturday',
            ];
            for ($x = 0; $x < count($request->request->get('classSubject')); $x++) {
                if (strtolower($request->request->get('lectureName')[$x]) == 'skip') {
                } else {

                    ## save Class Segment
                    if (empty($request->request->get('teacher')[$x])) {
                        $this->addFlash(
                            'classOwnerShipFlashError',
                            'Teacher is not selected for Subject '.$request->request->get(
                                'subject'
                            )[$x].' of '.$weekDaysArray[$request->request->get('lectureDay')[$x]]
                        );
                    } elseif (empty($request->request->get('letctureStartTime')[$x])) {
                        $this->addFlash(
                            'classOwnerShipFlashError',
                            'Lecture start Time is not mentioned for Subject '.$request->request->get(
                                'subject'
                            )[$x].' of '.$weekDaysArray[$request->request->get('lectureDay')[$x]]
                        );
                    } elseif (empty($request->request->get('letctureEndTime')[$x])) {
                        $this->addFlash(
                            'classOwnerShipFlashError',
                            'Lecture End Time is not mentioned for Subject '.$request->request->get(
                                'subject'
                            )[$x].' of '.$weekDaysArray[$request->request->get('lectureDay')[$x]]
                        );
                    } else {
                        try {

                            $classTimeTableSegment = null;
                            if (!empty($request->request->get('class_time_table_segment')[$x])) {
                                $classTimeTableSegment = $this->entityManager->getRepository(
                                    'App:ClassTimeTableSegments'
                                )->find($request->request->get('class_time_table_segment')[$x]);
                            }

                            if (!$classTimeTableSegment instanceof ClassTimeTableSegments) {
                                $classTimeTableSegment = new ClassTimeTableSegments();
                            }

                            $classTimeTableSegment->setLectureDate(
                                $defaultFunction->convert_datetimeStringIntoObject(
                                    $request->request->get('lectureDate')[$x]
                                )
                            );
                            $classTimeTableSegment->setMeetingLink(
                                $request->request->get('lectureMeetingLink')[$x]
                            );
                            $classTimeTableSegment->setLectureDay(
                                $request->request->get('lectureDay')[$x]
                            );
                            $classTimeTableSegment->setClassSubject(
                                $this->entityManager->getRepository('App:ClassSubject')->find(
                                    $request->request->get('classSubject')[$x]
                                )
                            );
                            $classTimeTableSegment->setClassTimeTable(
                                $this->entityManager->getRepository('App:ClassTimeTable')->find(
                                    $request->request->get('classOwnerShip')
                                )
                            );
                            $classTimeTableSegment->setClass(
                                $this->entityManager->getRepository('App:Classes')->find(
                                    $request->request->get('classId')
                                )
                            );
                            $classTimeTableSegment->setTeacher(
                                $this->entityManager->getRepository('App:User')->find(
                                    $request->request->get('teacher')[$x]
                                )
                            );
                            $classTimeTableSegment->setTeacherBackup(
                                $this->entityManager->getRepository('App:User')->find(
                                    $request->request->get('teacher_two')[$x]
                                )
                            );
                            $classTimeTableSegment->setLectureName(
                                empty($request->request->get('lectureName')[$x]) ?
                                    $request->request->get('class_name')."'s Lecture of ".$request->request->get(
                                        'subject'
                                    )[$x].' Lecture'
                                    : $request->request->get(
                                    'lectureName'
                                )[$x]
                            );
                            $classTimeTableSegment->setLectureDuration(
                                $request->request->get('lectureDuration')[$x]
                            );
                            $classTimeTableSegment->setLectureStartTime(
                                $defaultFunction->convert_datetimeStringIntoObject(
                                    $request->request->get('letctureStartTime')[$x]
                                )
                            );
                            $classTimeTableSegment->setLectureEndTime(
                                $defaultFunction->convert_datetimeStringIntoObject(
                                    $request->request->get('letctureEndTime')[$x]
                                )
                            );
                            $classTimeTableSegment->setLectureDescription(
                                $request->request->get('lecturePurpose')[$x]
                            );
                            $this->entityManager->persist($classTimeTableSegment);
                            $this->entityManager->flush();

                        } catch (\Exception $exception) {
                            $this->addFlash('classOwnerShipFlashError', $exception->getMessage());
                        }
                    }
                }
            }


            $this->addFlash('classOwnerShipFlashSuccess', 'Subjects Time has been Scheduled ');


            return $this->redirectToRoute(
                'subject_ownership_list',
                ['classId' => $request->request->get('classId')]
            );


//            if (!empty($request->request->get('breakDuration'))) {
//                $classTimeTableSegment = new ClassTimeTableSegments();
//
//
//                $classTimeTableSegment->setLectureDay(1);
//
//                $classTimeTableSegment->setClassTimeTable(
//                    $this->entityManager->getRepository('App:ClassTimeTable')->find(
//                        $request->request->get('classOwnerShip')
//                    )
//                );
//                $classTimeTableSegment->setClass(
//                    $this->entityManager->getRepository('App:Classes')->find($request->request->get('classId'))
//                );
//                $classTimeTableSegment->setLectureName('Break');
//                $classTimeTableSegment->setLectureDuration($request->request->get('breakDuration'));
//                $classTimeTableSegment->setLectureStartTime(
//                    $defaultFunction->convert_datetimeStringIntoObject(
//                        $request->request->get('breakStartTime')
//                    )
//                );
//                $classTimeTableSegment->setLectureEndTime(
//                    $defaultFunction->convert_datetimeStringIntoObject(
//                        $request->request->get('breakEndTime')
//                    )
//                );
//                $classTimeTableSegment->setLectureDate(
//                    $defaultFunction->convert_datetimeStringIntoObject(
//                        $request->request->get('lectureDate')[$x]
//                    )
//                );
//                $this->entityManager->persist($classTimeTableSegment);
//                $this->entityManager->flush();
//            }

        } else {
            $isNewlyAdded = false;
        }

        ## if request to edit the single time table of subject
        if ($request->request->get('class_time_table_segment_id')) {
            return $this->redirectToRoute(
                'edit_single_time_table',
                [
                    'class_time_table_segment_id' => $request->request->get('class_time_table_segment_id'),
                ]
            );
        }


        $classTimeTableSegmentsInfoArr = null;
        ## edit calendar
        if ($request->query->get('edit')) {

            $classTimeTableSegments = $this->entityManager->getRepository('App:ClassTimeTableSegments')->findBy(
                [
                    'class_time_table' => $class_owner_ship_id,
                ]
            );

            foreach ($classTimeTableSegments as $classTimeTableSegmentVal) {
                /** @var ClassTimeTableSegments $classTimeTableSegmentVal */
                $classTimeTableSegmentsInfoArr[$classTimeTableSegmentVal->getClassSubject()->getId(
                )][$classTimeTableSegmentVal->getLectureDay()] = $classTimeTableSegmentVal;
            }
        }

        return $this->render(
            'subject/ownership/ownership.html.twig',
            [
                'class_subject' => $this->entityManager->getRepository('App:ClassSubject')->findBy(
                    [
                        'classes__' => $class_id,
                        'is_deleted' => 0,
                    ]
                ),
                'teachers' => $this->entityManager->getRepository('App:User')->findBy(
                    [
                        'category' => TeacherController::userCategory,
                        'is_active' => 1,
                        'is_deleted' => 0,
                    ]
                ),
                'class' => $this->entityManager->getRepository('App:Classes')->find($class_id),
                'classTimeTable' => $this->entityManager->getRepository('App:ClassTimeTable')->find(
                    $class_owner_ship_id
                ),
                'classTimeTableSegmentsInfoArr' => $classTimeTableSegmentsInfoArr,
                'is_newly_added' => $isNewlyAdded,
            ]
        );
    }


    /**
     * @Route("/subject/owner-ship-list/{classId}/{date}", name="subject_ownership_list", defaults={"date":null, "classId":null})
     * @param SubjectService $subjectService
     * @param DefaultFunction $defaultFunction
     * @param null $date
     * @param null $classId
     * @param StudentClasses $studentClasses
     * @param \Symfony\Component\HttpFoundation\Request $request
     * @param AppSettings $appSettings
     * @return Response
     */
    public function assign_teachers_to_class_subject_lecture_list(
        SubjectService $subjectService,
        DefaultFunction $defaultFunction,
        $date = null,
        $classId = null,
        StudentClasses $studentClasses,
        \Symfony\Component\HttpFoundation\Request $request,
        TriggerNotifications $triggerNotifications
    ) {

        if (empty($date)) {
            $date = date('Y-d-M');
        }
        if (!$classId) {
            $classId = $request->query->get('class');
        }

        $classRoutines = $this->entityManager->getRepository('App:ClassTimeTableSegments')->findBy(
            [
                'class' => $classId,
            ]
        );

        $classRoutineArrayMap = [];
        /** @var ClassTimeTableSegments $classRoutine */
        foreach ($classRoutines as $classRoutine) {
            $classRoutineArrayMap[$classRoutine->getClassSubject()->getId()][$classRoutine->getLectureDay(
            )] = $classRoutine;
        }

        ## class Time table from Class
        $classTimeTable = $this->entityManager->getRepository('App:ClassTimeTable')->findOneBy(
            [
                'class' => $classId,
            ]
        );
        ## parameters send to the function.
        $params = new ParameterBag();
        $params->set('referece_', $classId);

        /** @var ClassTimeTable $classTimeTable */
        $passParam = [
            'classTimeTable' => $classTimeTable,
            'classRoutines' => $classRoutineArrayMap,
            'class_subjects' => $subjectService->get__subjectsFromClassSubjectTable($params),
            'classes' => $studentClasses->getAllClasses(null),
        ];

        ## print pdf report
        if ($request->query->get('printResult') == 1 && $classTimeTable instanceof ClassTimeTable) {
            $class_name = $classTimeTable->getClass()->getName();
            $filename = $class_name.' Class Schedule';
            $reportFile = null;
            if (empty($reportFile)) {
                $reportFile = 'pdfPrints/schedule.root/default.html.twig';
            }
            $passParam['filename'] = $filename;
            $passParam['class_name'] = $class_name;
            $html_fe = $this->renderView($reportFile, $passParam);

            return new ResponseAlias(
                $this->pdf->getOutputFromHtml($html_fe), 200, [
                    'Content-Type' => 'application/pdf',
                    'Content-Disposition' => 'inline; filename="'.$filename.'.pdf"',
                ]
            );
        }

        ## send message to gurdian
        if ($request->query->get('sendMessageToGuardian') == 1) {
            $class_name = $classTimeTable->getClass()->getName();
            $filename = $class_name.' Class Schedule';
            $reportFile = 'pdfPrints/schedule.root/only.table.html.twig';
            $passParam['filename'] = $filename;
            $passParam['class_name'] = $class_name;
            $html_fe = $this->renderView($reportFile, $passParam);
            $classTimeTable->sendMessageToGuardian($triggerNotifications, $this->entityManager, $html_fe, $class_name);
            $this->addFlash('classOwnerShipFlashSuccess', 'Messages has been sent to Guardian');
        }

        return $this->render(
            'class/TimeTable/class_time_table_list.html.twig',
            $passParam
        );
    }

    /**
     * @Route("/class-time-table/edit/{class_time_table_segment_id}", name="edit_single_time_table")
     * @param $class_time_table_segment_id
     * @return Response
     */
    public function edit_single_time_table($class_time_table_segment_id)
    {
        return $this->render(
            'class/TimeTable/edit_single_time_table.html.twig',
            [
                'class_time_table' => $this->entityManager->getRepository('App:ClassTimeTableSegments')->find(
                    $class_time_table_segment_id
                ),
                'teachers' => $this->entityManager->getRepository('App:User')->findBy(
                    [
                        'category' => TeacherController::userCategory,
                        'is_active' => 1,
                        'is_deleted' => 0,
                    ]
                ),
            ]
        );
    }
}
