<?php


namespace App\Service\ScheduleMessagesService;


use App\Entity\ScheduleMessage;
use App\Repository\ScheduleMessageRepository;
use App\Service\DefaultFunction;
use App\Service\Guardian\GuardianService;
use App\Service\Teacher\teacherAllocationService;
use App\Service\TriggerNotifications;
use App\Service\UserService;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Snappy\Pdf;
use Symfony\Component\HttpFoundation\ParameterBag;

class ThrowMessages extends Base {

	/**
	 * @var ScheduleMessageRepository
	 */
	protected $scheduleMessageRepository;
	/**
	 * @var TriggerNotifications
	 */
	private $triggerNotifications;

	public function __construct( TriggerNotifications $triggerNotifications, DefaultFunction $defaultFunction, Pdf $pdf, EntityManagerInterface $entityManager, ScheduleMessageRepository $scheduleMessageRepository, UserService $userService, GuardianService $guardianService, teacherAllocationService $teacherAllocationService, Files $files ) {
		parent::__construct( $defaultFunction, $pdf, $entityManager, $scheduleMessageRepository, $userService, $guardianService, $teacherAllocationService, $files );
		$this->triggerNotifications = $triggerNotifications;
	}

	/**
	 * Purpose: List of the message, which we need to send
	 *
	 * @return mixed
	 */
	public function getScheduleMessageThatNeedToSend() {
		$bag = new ParameterBag();
		$bag->set( 'not_sent', false );
		$bag->set( 'sent_dateTime', date( 'Y-m-d H:i:00' ) );
		$bag->set( 'equality', false );

		return $this->scheduleMessageRepository->advanceSearch( $bag );

	}

	/**
	 * Purpose Send Email and Messages.
	 */
	public function triggerScheduleMessage() {
		$listOfScheduleMessage = $this->getScheduleMessageThatNeedToSend();
		$params['event_name']  = 'REPORT_NOTIFICATION';
		/** @var ScheduleMessage $value */
		foreach ( $listOfScheduleMessage as $key => $value ) {
			$user                  = $value->getSentTo();
			$params['user']        = $user;
			$params['attachments'] = $this->getMessageScheduleAttachment( $value->getId() );
			$this->triggerNotifications->triggerNotifications( $params );
		}
	}
}