<?php


namespace App\Service;


use App\Entity\Guardian;
use App\Entity\User;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Csrf\TokenStorage\TokenStorageInterface;
use Symfony\Component\Validator\ConstraintViolation;
use Symfony\Component\Validator\ConstraintViolationList;
use Symfony\Component\Validator\ConstraintViolationListInterface;

class DefaultFunction
{


    /**
     * @var AppSettings
     */
    private $app_settings;

    /*
     * default date format
     * */
    private $default_dateFormat = 'd D, M Y ';

    /*
     *default time format
     * */
    private $default_timeFormat = 'h:i a';
    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var TokenStorageInterface
     */
    private $token_storage;
    /**
     * @var ParameterBagInterface
     */
    private $parameter_bag;


    public function __construct(
        AppSettings $app_settings,
        RouterInterface $router,
        TokenStorageInterface $token_storage,
        ParameterBagInterface $parameter_bag
    ) {
        $this->app_settings = $app_settings;
        $this->router = $router;
        $this->token_storage = $token_storage;
        $this->parameter_bag = $parameter_bag;
    }

    /*
     * PURPOSE:  Each & every application will used, his own defined format so, this helper will convert date format according to user selected date format
     * */
    public function date__($date)
    {
        ##
        $response = '';

        ## if given date is empty
        if ($date <> '') {
            $date = strtotime($date);
        }

        ## get the user defined format.
        $dateFormat = $this->app_settings->getAppSettingsFromSessions('date_format');
        if (!empty($dateFormat)) {
            $response = date($dateFormat, $date);
        } else {
            $response = date($this->default_dateFormat, $date);
        }

        ## return the response.
        return $response;
    }

    public function time__($time)
    {
        ## if given date is empty
        if ($time <> '') {
            $time = strtotime($time);
        }

        ## get the user defined format.
        $timeFormat = $this->app_settings->getAppSettingsFromSessions('time_format');
        if (!empty($timeFormat)) {
            $response = date($timeFormat, $time);
        } else {
            $response = date($this->default_timeFormat, $time);
        }

        ## return the response.
        return $response;
    }


    /**
     * @param $error_collection
     * @param $error
     *
     * This function collect functions response and check if response of the function is in not equal to  'OK' then
     * save error in the bag.
     *
     * @return mixed
     */
    public function push_error(array $error_collection, $error)
    {
        if ($error <> 'OK') {
            array_push($error_collection, $error);
        }

        return $error_collection;
    }

    /**
     * Purpose: Parse symfony array errors into string.
     * @param ConstraintViolationListInterface $errors
     * @return array|mixed
     */
    public function parseConstraintViolationInString(ConstraintViolationListInterface $errors)
    {
        $array = [];
        /** @var ConstraintViolation $value */
        foreach ($errors as $key => $value) {
            $array = $this->push_error($array, $value->getMessage());
        }

        return $array;

    }


    /*
     * Encoder decoder for the file server.
     * */
    public function encoder_decoder(?string $string, ?bool $encode = true)
    {
        ## if given string is empty then send the user back to interface.
        if (empty($string)) {
            return 'Invalid string';
        }
        if ($encode) {
            // would like to encode the given string
            $response = base64_encode( /*urlencode*/ ($string));

        } else {
            // would like to decode the given string.
            $response = base64_decode( /*urldecode*/ ($string));
        }

        return $response;
    }


    /**
     * Redirect if user is not logged in.
     *
     * @return string
     */
    public function redirect_to_login_page_if_user_not_loggedIn(User $user)
    {

        if (!in_array('ROLE_USER', $user->getRoles())) {
            ## if user is already logged in then redirect to the home page.
            $defaultLocale = $this->app_settings->getAppSettingsFromSessions('default_language');

            return $this->router->generate('HomePage', ['_locale' => $defaultLocale]);
        }
    }


    /**
     * Redirect to hom Page
     *
     * @return string
     */
    public function redirectToHomePage()
    {
        ## if user is already logged in then redirect to the home page.
        $defaultLocale = $this->app_settings->getAppSettingsFromSessions('default_language');

        return $this->router->generate('HomePage', ['_locale' => $defaultLocale]);
    }

    /**
     * PURPOSE: Generate url
     *
     * @param $urlName
     * @param $parameters
     *
     * @return string
     */
    public function generateURL(string $urlName, array $parameters = [])
    {
        ## if user is already logged in then redirect to the home page.
        $defaultLocale = $this->app_settings->getAppSettingsFromSessions('default_language');
        $parameters['_locale'] = $defaultLocale;

        return $this->router->generate($urlName, $parameters);
    }

    ## parse the value to the boolean to store data in the column.
    ## 1 is for the false and 2 is for the true.
    public function parse__boolean($value)
    {
        $response = false;
        if ($value == 2 || $value == 'on') {
            $response = true;
        }

        return $response;

    }

    ## parse the value to the boolean
    public function parse__YesNoToBoolean($value)
    {
        $response = false;
        if ($value == 'yes') {
            $response = true;
        }

        return $response;

    }

    ## convert datetime string into object.
    public function convert_datetimeStringIntoObject($datetime)
    {
        ## if datetime is instance of datetime then we not need to convert it.
        if ($datetime instanceof \DateTime) {
            return $datetime;
        }

        $datetime_ = new \DateTime('now');
        if (!empty($datetime)) {
            try {
                $datetime_ = new \DateTime($datetime);
            } catch (\Exception $exception) {
            }
        }

        return $datetime_;
    }

    ## findOut error in the bulk operation.
    public function purify_success_error_response_in_bulk_operation($response)
    {
        $__response = $response;
        $erro_counter = 0;

        ## if response is array
        if (is_array($response)) {
            ## count error
            foreach ($response as $value) {
                ## if we found an error then increase value by one.
                if ($value <> 'OK') {
                    $erro_counter++;
                }
            }
        } else {
            if ($response <> 'OK' && !is_array($response)) {
                $erro_counter++;
            }
        }

        ## if no error mark the response that everything is okay.
        if (empty($erro_counter)) {
            $__response = 'OK';
        }

        return $__response;
    }

    /**
     *
     * @param $dateTime1
     * @param $dateTime2
     * @return bool|string
     *
     * this function use to compare datetime.
     * function return true if datetime 1 is future date
     */
    public function compare__two_datetime($dateTime1, $dateTime2)
    {
        $response = false;
        if (empty($dateTime1) || empty($dateTime2)) {
            ## datetime is  invalid
            $response = false;
        } else {
            $dateTime1 = $this->convert_datetimeStringIntoObject($dateTime1);
            $dateTime1 = $dateTime1->format('d-M-Y h:i:s A');
            $dateTime2 = $this->convert_datetimeStringIntoObject($dateTime2);
            $dateTime2 = $dateTime2->format('d-M-Y h:i:s A');

            if (strtotime($dateTime1) > strtotime($dateTime2)) {
                $response = true;
            }
        }

        return $response;
    }

    /**
     *  return the list of date available in two dates interval
     *
     * @param $dateInternal : sample -> (date1 / date2)
     *
     * @return \DatePeriod|string|null
     * @throws \Exception
     */
    public function listOfDatesBetweenTwoDatesInterval($dateInternal)
    {
        $response = null;
        $attendanceDate = explode(' / ', $dateInternal);
        if (is_array($attendanceDate)) {

            $endDate = new \DateTime($attendanceDate[1]);
            $endDate->modify('+1 day');

            $response = new \DatePeriod(new \DateTime($attendanceDate[0]), new \DateInterval('P1D'), $endDate);
        } else {
            $response = 'Invalid value supplied';
        }

        return $response;
    }

    ## parse template from the full path
    public function parseTemplatePathFromFullPath(string $fullPath)
    {
        return strtr(
            $fullPath,
            [
                $this->parameter_bag->get('RootPath').'templates/' => '',
            ]
        );
    }

    /**
     * Get application base url
     * Condition: Method should return without / at the end.
     * */
    public function getAppBaseUrl()
    {
        $appURL = $this->app_settings->getAppSettingsFromSessions('school_secure_url');
        if (empty($appURL)) {
            $appURL = $this->app_settings->getAppSettingsFromSessions('school_url');
        }

        return $appURL;
    }
}
