<?php


namespace App\Service;


use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class ApiHelpers {


	public function __construct() {
	}

	public function api_response( $data, ?bool $relationalData = false ) {

		## if database
		if ( $relationalData ) {
			$encoders       = [ new JsonEncoder() ];
			$defaultContext = [
				AbstractNormalizer::CIRCULAR_REFERENCE_HANDLER => function ( $object, $format, $context ) {
				},
			];
			$normalizer     = [ new ObjectNormalizer( null, null, null, null, null, null, $defaultContext ) ];
		} else {

		}

		$serializer = new Serializer( $normalizer, $encoders );
		$data       = $serializer->serialize( $data, 'json' );

		return new JsonResponse( $data, 200 );
	}

}