<?php

namespace App\Repository;

use App\Entity\InternalChatGroups;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method InternalChatGroups|null find( $id, $lockMode = null, $lockVersion = null )
 * @method InternalChatGroups|null findOneBy( array $criteria, array $orderBy = null )
 * @method InternalChatGroups[]    findAll()
 * @method InternalChatGroups[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class InternalChatGroupsRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, InternalChatGroups::class );
	}

	## get the list of groups in which given user is involved
	public function get_the_chat_group_list_in_which_user_involved( int $userRef ) {
		return $this->createQueryBuilder( 'internalChatGroups' )
		            ->leftJoin( 'internalChatGroups.internalChatGroupUsers', 'internalChatGroupUsers' )
		            ->where( 'internalChatGroupUsers.involved_users =:user_ref' )
		            ->setParameter( 'user_ref', $userRef )
		            ->getQuery()
		            ->getResult();
	}
}
