<?php

namespace App\Repository;

use App\Entity\ClassFeeSchedule;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method ClassFeeSchedule|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassFeeSchedule|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassFeeSchedule[]    findAll()
 * @method ClassFeeSchedule[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassFeeScheduleRepository extends ServiceEntityRepository
{

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassFeeSchedule::class);
    }

    ## get the Admission class fee
    public function getAdmissionClassFee(int $ClassID, $getTotalAmount = false)
    {
        $queryBuilder = $this->createQueryBuilder('class_fee_schedule');

        ## get the total amount
        if ($getTotalAmount) {
            ## find the total amount
            $queryBuilder->select('SUM(class_fee_schedule.amount)');
        }
        ## get the class fee on base of class and admission fee
        $queryBuilder = $queryBuilder->andWhere('class_fee_schedule.is_admission_fee = 1')
            ->andWhere('class_fee_schedule.class = :class')
            ->setParameter('class', $ClassID)
            ->getQuery();

        if ($getTotalAmount) {
            ## get the total amount
            try {
                $queryBuilder = $queryBuilder->getSingleScalarResult();
            } catch (NonUniqueResultException $e) {
                $queryBuilder = $e->getMessage();
            }
        } else {
            ## get the results.
            $queryBuilder = $queryBuilder->getResult();
        }


        ## return result or error message, if we have.
        return $queryBuilder;

    }

    public function listOfFees(bool $parse__YesNoToBoolean)
    {
        ## query builder
        $queryBuilder = $this->createQueryBuilder('class_fee_schedule');

        ## ignore delete records
        if (!$parse__YesNoToBoolean) {
            $queryBuilder = $queryBuilder->andWhere('class_fee_schedule.is_deleted = 0');
        }

        return $queryBuilder->orderBy('class_fee_schedule.is_deleted', 'ASC')->getQuery()->getResult();

    }

}
