<?php

namespace App\Form;

use App\Entity\User;
use App\Form\Model\UserLoginFormModel;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class UserLoginFormType extends AbstractType {

	public function buildForm( FormBuilderInterface $builder, array $options ) {
		$builder->add( 'authBy', null, [
			'label'      => false,
			'attr'       => [
				'placeholder' => 'Email / Security Number',
			],
			'empty_data' => 'ddd-fe',
			'data'       => 'dd-feds',
		] )->add( 'password', PasswordType::class, [
			'label'      => false,
			'attr'       => [
				'placeholder' => 'Password',
			],
			'empty_data' => 'dd-feds',
			'data' => 'dd-feds',
		] );

	}

	public function configureOptions( OptionsResolver $resolver ) {
		$resolver->setDefaults( [
			// Configure your form options here
			'attr' => [
				'class'         => 'kt-form',
				// an arbitrary string used to generate the value of the token
				// using a different string for each form improves its security
				'csrf_token_id' => 'helloWorld',
				'csrf_protection' => false,
			],
		] );
	}
}
