<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InternalChatGroupsRepository")
 */
class InternalChatGroups {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=60)
	 */
	private $icg_name;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	private $icg_description;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="internal_chat_group_created_by")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $icg_created_by;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="internal_chat_group_admin")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $icg_admin;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\InternalChatGroupUsers", mappedBy="icg")
	 */
	private $internalChatGroupUsers;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\InternalChatGroupsGuardian", mappedBy="icg")
	 */
	private $internalChatGroupsGuardians;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\InternalChat", mappedBy="chat_group")
	 */
	private $internal_chat_messages;

	public function __construct() {
		$this->internalChatGroupUsers      = new ArrayCollection();
		$this->internalChatGroupsGuardians = new ArrayCollection();
		$this->internal_chat_messages      = new ArrayCollection();
	}

	public function getId(): ?int {
		return $this->id;
	}

	public function getIcgName(): ?string {
		return $this->icg_name;
	}

	public function setIcgName( string $icg_name ): self {
		$this->icg_name = $icg_name;

		return $this;
	}

	public function getIcgDescription(): ?string {
		return $this->icg_description;
	}

	public function setIcgDescription( ?string $icg_description ): self {
		$this->icg_description = $icg_description;

		return $this;
	}

	public function getIcgCreatedBy(): ?User {
		return $this->icg_created_by;
	}

	public function setIcgCreatedBy( ?User $icg_created_by ): self {
		$this->icg_created_by = $icg_created_by;

		return $this;
	}

	public function getIcgAdmin(): ?User {
		return $this->icg_admin;
	}

	public function setIcgAdmin( ?User $icg_admin ): self {
		$this->icg_admin = $icg_admin;

		return $this;
	}

	/**
	 * @return Collection|InternalChatGroupUsers[]
	 */
	public function getInternalChatGroupUsers(): Collection {
		return $this->internalChatGroupUsers;
	}

	public function addInternalChatGroupUser( InternalChatGroupUsers $internalChatGroupUser ): self {
		if ( ! $this->internalChatGroupUsers->contains( $internalChatGroupUser ) ) {
			$this->internalChatGroupUsers[] = $internalChatGroupUser;
			$internalChatGroupUser->setIcg( $this );
		}

		return $this;
	}

	public function removeInternalChatGroupUser( InternalChatGroupUsers $internalChatGroupUser ): self {
		if ( $this->internalChatGroupUsers->contains( $internalChatGroupUser ) ) {
			$this->internalChatGroupUsers->removeElement( $internalChatGroupUser );
			// set the owning side to null (unless already changed)
			if ( $internalChatGroupUser->getIcg() === $this ) {
				$internalChatGroupUser->setIcg( null );
			}
		}

		return $this;
	}

	/**
	 * @return Collection|InternalChatGroupsGuardian[]
	 */
	public function getInternalChatGroupsGuardians(): Collection {
		return $this->internalChatGroupsGuardians;
	}

	public function addInternalChatGroupsGuardian( InternalChatGroupsGuardian $internalChatGroupsGuardian ): self {
		if ( ! $this->internalChatGroupsGuardians->contains( $internalChatGroupsGuardian ) ) {
			$this->internalChatGroupsGuardians[] = $internalChatGroupsGuardian;
			$internalChatGroupsGuardian->setIcg( $this );
		}

		return $this;
	}

	public function removeInternalChatGroupsGuardian( InternalChatGroupsGuardian $internalChatGroupsGuardian ): self {
		if ( $this->internalChatGroupsGuardians->contains( $internalChatGroupsGuardian ) ) {
			$this->internalChatGroupsGuardians->removeElement( $internalChatGroupsGuardian );
			// set the owning side to null (unless already changed)
			if ( $internalChatGroupsGuardian->getIcg() === $this ) {
				$internalChatGroupsGuardian->setIcg( null );
			}
		}

		return $this;
	}

	/**
	 * @return Collection|InternalChat[]
	 */
	public function getInternalChatMessages(): Collection {
		return $this->internal_chat_messages;
	}

	public function addInternalChatMessage( InternalChat $internalChatMessage ): self {
		if ( ! $this->internal_chat_messages->contains( $internalChatMessage ) ) {
			$this->internal_chat_messages[] = $internalChatMessage;
			$internalChatMessage->setChatGroup( $this );
		}

		return $this;
	}

	public function removeInternalChatMessage( InternalChat $internalChatMessage ): self {
		if ( $this->internal_chat_messages->contains( $internalChatMessage ) ) {
			$this->internal_chat_messages->removeElement( $internalChatMessage );
			// set the owning side to null (unless already changed)
			if ( $internalChatMessage->getChatGroup() === $this ) {
				$internalChatMessage->setChatGroup( null );
			}
		}

		return $this;
	}
}
