<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;

class CustomFieldSections extends Fixture {


	private $faker;

	public function load( ObjectManager $manager ) {

		$this->faker = Factory::create();
		for ( $x = 0; $x < 10; $x ++ ) {
			$customF_S = new \App\Entity\CustomFieldSections();
			$customF_S->setName( $this->faker->name );
			$customF_S->setDescription( $this->faker->sentence );
			$customF_S->setSortingOrder( rand() );
			$this->addReference( CustomFieldFixtures::CustomFieldSectionsReference . '_' . $x, $customF_S );
			$manager->persist( $customF_S );
		}

		$manager->flush();
	}
}
