<?php

namespace App\Controller;

use App\Entity\AppSettings;
use App\Service\DefaultFunction;
use App\Service\FileManagment;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class FileServerController extends AbstractController {

	/**
	 * @var DefaultFunction
	 */
	private $default_function;
	/**
	 * @var \App\Service\AppSettings
	 */
	private $app_settings;
	/**
	 * @var ParameterBag
	 */
	private $parameterBag;
	/**
	 * @var FileManagment
	 */
	private $fileManagment;

	public function __construct( DefaultFunction $default_function, \App\Service\AppSettings $app_settings, ParameterBagInterface $parameterBag, FileManagment $fileManagment ) {
		$this->default_function = $default_function;
		$this->app_settings     = $app_settings;
		$this->parameterBag     = $parameterBag;
		$this->fileManagment    = $fileManagment;
	}

	## file server, which is used to server files from the app.
	public function fileServer( $filePath ) {

		## if file path is empty then send him to login page.
		if ( empty( $filePath ) ) {
			## redirect to the home page
			return $this->redirect( $this->default_function->redirectToHomePage() );
		}

		## decode the file.
		$filePath = $this->default_function->encoder_decoder( (string) $filePath, false );


        ## getting file absolute path
		$filePath = $this->fileManagment->getAbsolutePathOfFile( $filePath );


		## check file existence.
		if ( ! is_file( $filePath ) || is_array( $filePath ) ) {
			## redirect to the home page
			return $this->redirect( $this->default_function->redirectToHomePage() );
		}

		return new BinaryFileResponse( $filePath );
	}


	/**
	 * @Route("/file/server/", name="unsecure_file_server")
	 * @param Request $request
	 *
	 * @return string|BinaryFileResponse
	 * PURPOSE: Make uploaded file secure
	 */
	public function UnSecureFiles( Request $request ) {
		return $this->fileServer( $request->query->get( 'filePath', null ) );
	}

	/**
	 * @IsGranted("ROLE_USER")
	 * @Route("/file/server/secure/", name="secure_file_server")
	 * @param Request $request
	 *
	 * @return string|BinaryFileResponse
	 * PURPOSE: Make uploaded file secure
	 */
	public function SecureFiles( Request $request ) {
		return $this->fileServer( $request->query->get( 'filePath', null ) );
	}

}
