"use strict";

import {DashBoard} from "../dashboard__";
import isEmpty = Handlebars.Utils.isEmpty;
import {select_initializer} from "../libraries/select2";
import {BaseFile} from "../base";
import {datepicker_initializer} from "../libraries/datepicker";
import {timepicker_initializer} from "../libraries/timepicker";
import {stringify} from "querystring";

let ex__form__without__hash = '__exm_inf';
let ex__form__ = '#__exm_inf';

let ex___schedule = '#__exm_sch';
let ex___schedule_without__hash = '__exm_sch';

let examiner_form__without_hash = '__exmIn_inf';
let examiner_form__ = '#__exmIn_inf';

let marking__exams_form__without__hash = '__fex__clsStud';
let marking__exams_form_ = '#__fex__clsStud';

class Exams {
    constructor() {
    }

    static Initialize = () => {
        // init select2
        select_initializer.simpleSelect2();
        datepicker_initializer.basic();
        timepicker_initializer.basic();
    };

    // sending ajax request.
    static ajaxHandler = (Object, absoulteUrl = BaseFile.getPageUrl(), callBackFunction = null) => {
        // show all message before sending any other request.
        BaseFile.removeServerResponse();

        $.ajax({
            method: 'POST',
            data: Object.dataToSend,
            url: absoulteUrl + '?query=' + Object.sendTo,
            success: function (data) {
                Exams.post_ajax(Object, data, callBackFunction);
                if (data.status === 'OK') {
                    BaseFile.handleRemoteAjaxResponse('OK');
                } else {
                    BaseFile.handleRemoteAjaxResponse(data);
                }
            }, error: function (err) {
                BaseFile.invalidAjaxRequest(err);
            }

        });
    };
    // after ajax request manipulate the data and do other operations
    static post_ajax = (Object, dataFromServerReponse, callBackFunction) => {
        // when adding or updating exams
        if (Object.sendTo === 'ex__m') {
            BaseFile.ReplaceRecordsWhenEdit(dataFromServerReponse, 'inv___usage___t', ex__form__without__hash);
            window
                .location.reload();
        }

        // when adding exam schedule.
        if (Object.sendTo === 'ex__cls') {
            BaseFile.ResetForm(ex___schedule_without__hash, true);
            // window.location.reload();
        }

        // when adding examiner.
        if (Object.sendTo === 'ex__mine') {
            BaseFile.ReplaceRecordsWhenEdit(dataFromServerReponse, 'exIm-_____us_-sch', examiner_form__without_hash);
        }

        // when marking exams.
        if (Object.sendTo === 'ex__clsStud') {
            BaseFile.ReplaceRecordsWhenEdit(dataFromServerReponse, 'ex-_Marks____us_-sch', marking__exams_form__without__hash);
        }

        // replace subject dropdown with the new one..
        if (Object.sendTo === 'getTheSubjectsOfClass') {
            $('.subject__placement').html(dataFromServerReponse.substr(17));
            select_initializer.simpleSelect2();
        }

        // when subject are changed then load total marks plus passing marks.
        if (Object.sendTo === 'loadClassSubjectDetails') {
            if (!isEmpty(dataFromServerReponse.substr(17))) {
                dataFromServerReponse = JSON.parse(dataFromServerReponse.substr(17));
                $('input[name=ex__tM]').val(dataFromServerReponse.totalMarks);
                $('input[name=ex__PM]').val(dataFromServerReponse.passMarks);
            }
        }

        // when entering the marks of students
        if (Object.sendTo === 'enterMarksOfStudents') {
            window.location.reload();
        }

        if (typeof callBackFunction === 'function') {
            callBackFunction();
        }
        DashBoard.removeLoader();
    };


    // show edited content in the form.
    static show_edited_category_content = (reference__obejct, tr__prefix, objectWhatToFind, formReference) => {
        let category_ref = $(reference__obejct).parent('ul').attr('data-targetRef');

        let value = null;
        for (let l in objectWhatToFind) {
            // get the data which is in the tr or td.
            value = $('tr#' + tr__prefix + category_ref).find('.' + l).html();

            // if the value is not empty
            if (!isEmpty(value)) {
                if (objectWhatToFind[l].element === 'select') {

                    // get the selected option value
                    let valueee = $(objectWhatToFind[l].element + '[name=' + l + '] option:contains("' + value.trim() + '")').attr('value');
                    // then select the selected option and make it change able.
                    // @ts-ignore
                    $(objectWhatToFind[l].element + '[name=' + l + ']').val(valueee).select2().trigger('change');
                } else {
                    $(formReference).find(objectWhatToFind[l].element + '[name=' + l + ']').val(value.trim());
                }
            }
        }
    };


    // hide or show when edit or add data in the exams table.
    static hideShowAddEditButtonWhenEditOrAdd = () => {

    };
}


// when class is initialized.
$(function () {
    // initialize page.
    Exams.Initialize();

    /*
    * Exams
    * */
    // edit exams
    $(document).on('click', '.__edit_exM__lt', function (e) {
        e.preventDefault();
        let Object = {
            'ex___Ed': {'element': 'input'},
            'n__': {'element': 'input'},
            'e___d': {'element': 'textarea'},
        };
        Exams.show_edited_category_content($(this), 'ex_ls_td', Object, ex__form__);
    });
    // saving process of the exams.
    $(document).on('click', '.ef____dse', function () {
        DashBoard.showLoader();
        let the__form = $(this).attr('data-ref');
        let form__refere = 'form#' + the__form;
        let target_ = $(this).attr('data-target');
        if (!isEmpty(the__form) && $(form__refere).length > 0 && !isEmpty(target_)) {
            let Object = {
                dataToSend: $(form__refere).serialize(),
                sendTo: target_,
            };
            Exams.ajaxHandler(Object);
        }
    });


    /*
    *
    * Examiners
    * */
    // edit examiner
    $(document).on('click', '.__edit_exMina0n__lt', function (e) {
        e.preventDefault();
        let Object = {
            'exm___Ed': {'element': 'input'},
            'exc__urf': {'element': 'select'},
            'exc_c_rf': {'element': 'select'},
        };
        Exams.show_edited_category_content($(this), 'ex_exmin_td', Object, examiner_form__);
    });


    /**
     *
     * Exam schedule
     * */

    // load total marks and marks when subject are changed
    $(document).on('change', 'select.actuallSubjects', function () {

        let uri = $('.usC__ss__s').attr('data-path');
        if (!isEmpty(uri)) {
            DashBoard.showLoader();
            let Object = {
                dataToSend: {
                    // id of select2 which is selected.
                    referece_: $(this).val(),
                },
                sendTo: 'loadClassSubjectDetails',
            };
            // send the data object with the different controller.
            Exams.ajaxHandler(Object, uri);
        }
    });

    // load subject when class dropdown has changed some value.
    $(document).on('change', 'select[name=exC__cLs]', function () {
        DashBoard.showLoader();
        let Object = {
            dataToSend: {
                // id of select2 which is selected.
                referece_: $(this).val(),
                // there is button which is used to remove the subject if user want, hide this button from the ui because we are not providing multiple adding options.
                enable_removal: true,
                // show simple select2 expect multiple.
                use___classes: 'notEmpty',
                // what should be the name of the select tag
                select__name: $(this).attr('data-target-sub'),
            },
            sendTo: 'getTheSubjectsOfClass',
        };
        // send the data object with the different controller.
        Exams.ajaxHandler(Object, $('.usC__q__s').attr('data-path'));
    });

    /*
    * Marking exams.
    * */
    // edit exam marks sheet.
    $(document).on('click', '.__edit_markExmNum__lt', function (e) {
        e.preventDefault();
        let Object = {
            'ex_cS__Ed': {'element': 'input'},
            'exc_cs_ex': {'element': 'select'},
            'exc_cs_srf': {'element': 'select'},
            'exC__cLs': {'element': 'select'},
            'exc_cs_s': {'element': 'select'},
            'exc_cs_obtM': {'element': 'input'},
            'exc_cs_rMks': {'element': 'textarea'},
        };
        Exams.show_edited_category_content($(this), 'ex_MarkNum_td', Object, marking__exams_form_);
    });

    // edit marks for students
    $(document).on('click', '.enteringMarks', function (e) {
        e.preventDefault();

        DashBoard.showLoader();
        BaseFile.removeServerResponse();

        let formRef = 'markStudentExam';
        // do some action before sending request.
        (<any>$('#' + formRef)).ajaxSubmit({
            method: 'post',
            success: function (data) {
                // handle response.
                BaseFile.handleRemoteAjaxResponse(data);
                // remove loader
                DashBoard.removeLoader();
            },
            error: function (err1) {
                BaseFile.invalidAjaxRequest(err1);
            }
        });

    });

});
