"use strict";

import isEmpty = Handlebars.Utils.isEmpty;
import {select_initializer} from "../libraries/select2";
import {DashBoard} from "../dashboard__";
import {BaseFile} from "../base";

require('tinymce');
//
//require('tinymce/themes/modern/theme.min.js');
require('tinymce/themes/modern/theme.min.js');
require('tinymce/skins/lightgray/skin.min.css');
require('tinymce/skins/lightgray/content.min.css');

declare var tinyMCE: any;
declare var tinymce: any;

const TinyMaceAdvertisementDiv = 'div.tox-tinymce-aux';
const CurrentEditableLang = '#currentEditingLang';
const in_translation_input = 'input[name=lang]';
const assigned_to_input = 'input[name=assigned_to]';
const emailTemplateTabChangerLis = 'li.emailTemplateTabs';
const activeTabHead = '#activeTabHead';
const selectEmailTemplateListDropdownMainDiv = '#selectEmailTemplateListDropdown';
const selectEmailTemplateDropDown = 'select[name=templateName]';
const translationListLi = '.loadTranslatedTemplate';
var selectedTemplateId: any = '';
const templateSubjectInput = 'input[name=email_subject]';
const emailTemplateMessageType = '.templateTypeTabs a';
const detailMessageSaveButton = '.detail_message_save';
const c___remote_r = 'span.c___remote_r';
const s___remote_r = 'span.s___remote_r';

var availableVariables = {
    "s": {
        '{{ s_fname }}': 'Student first name',
        '{{ s_lname }}': 'Student last name',
        '{{ s_current_class }}': 'Class',
        '{{ s_subject }}': 'Subject',
        '{{ s_examDate }}': 'Exam Date',
        '{{ guardianName }}': 'Guardian name',
        '{{ s_obtain_marks }}': 'Obtain Marks',
        '{{ s_total_marks }}': 'Total Marks',
        '{{ s_attendance_status }}': 'Attendance status',
        '{{ s_attendance_date }}': 'Attendance Date',
        '{{ s_invoice_amount }}': 'Invoice Amount',
        '{{ s_invoice_due_date }}': 'Invoice Due Date',
        '{{ s_invoice_no }}': 'Invoice No',
        '{{ s_invoice_status }}': 'Invoice Status',
        '{{ s_resetPasswordLink }}': 'Password Reset Link',
        '{{ attendance_table }}': 'Attendance Table for Week/Class/Month',
        '{{ s_marks_class_table }}': 'Exam Table for Week/Class/Month',
        '{{ schedule_html_table }}': 'Class Schedule Table',
    },
    "t": {
        '{{ fname }}': 'teacher first name',
        '{{ lname }}': 'teacher last name',
    },
    "a": {
        '{{ fname }}': 'admi first name',
        '{{ lname }}': 'admin last name',
    },
    "g": {
        "{{ fname }}": "guardian name",
    },
    "ct": {
        "{{ fname }}": "name",
    }
};

class emailTemplateList {
    constructor() {
    }

    postInitWork = () => {
        var editor = tinyMCE.getInstanceById('testing___');
        editor.getBody().style.backgroundColor = "#ff6";
    };

    // Initialize, when pages loads complete.
    static Initialize = (userType = 's') => {

        //alert(emailTemplateList.getSelectedTemplateType('student').isEmpty());

        // Initialize tinymce with the custom dropdown.

        tinymce.init({
            selector: '.tinyMce',
            theme: 'modern',
            skin: "lightgray",
            toolbar: "shortcodes | mybutton | undo redo | forecolor backcolor | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image",
            image_advtab: true,
            height: 300,
            oninit: "postInitWork",
            setup: function (editor) {
                // for the tinymce version 5
                /*if (!isEmpty(emailTemplateList.getSelectedTemplateType(userType))) {
                    // if variable of selected user is not empty
                    var menuData = [];
                    $.each(emailTemplateList.getSelectedTemplateType(userType), function (i, row) {
                        menuData.push({
                            text: row,
                            onclick: function () {
                                editor.insertContent(i);
                            }
                        });
                    });

                    editor.ui.registry.addMenuButton('mybutton', {

                        text: 'Select Variables?',
                        icon: 'user',
                        menu: menuData,
                        fetch: function (callback) {

                            var menuData = [];
                            $.each(emailTemplateList.getSelectedTemplateType(userType), function (i, row) {
                                menuData.push({
                                    type: 'menuitem',
                                    text: i,
                                    onAction: function () {
                                        editor.insertContent('&nbsp;{{ ' + row + ' }}');
                                    }
                                });
                            });

                            /!*var items = [
                                {
                                    type: 'menuitem',
                                    text: 'Menu item 1',
                                    onAction: function () {
                                        editor.insertContent('&nbsp;<em>You clicked menu item 1!</em>');
                                    }
                                },
                            ];*!/
                            callback(menuData);
                        }
                    });
                }*/

                // for the tinymce version 4
                if (!isEmpty(emailTemplateList.getSelectedTemplateType(userType))) {
                    var menuData = [];
                    $.each(emailTemplateList.getSelectedTemplateType(userType), function (i, row) {
                        menuData.push({
                            text: row,
                            onclick: function () {
                                editor.insertContent(i);
                            }
                        });
                    });
                    editor.addButton('shortcodes', {
                        type: 'menubutton',
                        text: 'Select Fields',
                        icon: 'user',
                        menu: menuData
                    });

                }
            },
        });

        // remove loader.
        DashBoard.removeLoader();

        // remove tinymce promotional message.
        emailTemplateList.removePaidVersionAddsFromTinyMce();
    };

    // get selected template type.
    static getSelectedTemplateType = (whoes) => {
        return availableVariables[whoes]
    };

    // remove tinymce advertisement div.
    static removePaidVersionAddsFromTinyMce = () => {
        let TinyMcePaidNotificationInterval = setInterval(function () {

            if ($(TinyMaceAdvertisementDiv).is(':visible')) {
                //$(TinyMaceAdvertisementDiv).remove();
//                $('button.tox-notification__dismiss').toggle('click');
            } else {
                clearInterval(TinyMcePaidNotificationInterval);
            }
        }, 500);

    };

    // when user, change language to translate email template into other language.
    static updateTemplateInOtherLanguage = (thiss) => {
        //$(in_translation_input).attr('value', $(thiss).attr('dataLang'));
        $(CurrentEditableLang).html($(thiss).text().trim());
        $(CurrentEditableLang).attr('data-lang', $(thiss).attr('dataLang'));

    };

    // destroy tinymce.
    static DestroyTinyMce = (Id = 'template_messages') => {
        tinymce.remove('#' + Id);
    };

    // tabs changer
    static tabChanger = (thiss) => {
        // reset main content.
        emailTemplateList.ResetEmailDetails();
        // destroy tinymce to laod new variables.
        emailTemplateList.DestroyTinyMce();

        // make all tabs in active.
        $(emailTemplateTabChangerLis).children('a.kt-widget__item').removeClass('active');
        $('.editingTemplateTab').removeClass('active');
        // make clicked li active.
        $(thiss).children('a.kt-widget__item').addClass('active');
        // display template header heading... teacher, student, staff or guradian.
        $(activeTabHead).html($(thiss).find('span.kt-widget__desc').html().trim());

        // loading templates from server.
        emailTemplateList.pre_ajax('dropdown', {'assignedTo': $(thiss).attr('data-assignedTo')});
        // change assigned to when tab is changed.
        $(assigned_to_input).attr('value', $(thiss).attr('data-assignedTo'));
        // update tinymce variables according to the category of users.
        emailTemplateList.Initialize($(thiss).attr('data-assignedTo'));
    };

    // reset email details.
    static ResetEmailDetails = () => {
        // reset subject.
        $(templateSubjectInput).val('');
        // reset template content.
        tinyMCE.get('template_messages').setContent('');
    };

    // pre ajax, we are using on ajax method to do different tasks, so we've to send multiple type of data to request something.
    static pre_ajax = (type = 'dropdown', ExtraInfo: object = {}) => {

        let dataObject = {};

        if (type === 'dropdown') {
            dataObject = {
                "assigned_to": ExtraInfo['assignedTo'],
                'view': 'email_templates/ajaxPatches/selectTemplateToEditDropdown.html.twig',
                'requestFor': 'dropdown',
                'request_type': 'POST',
            };

            // request to server for loading data.
            emailTemplateList.loadRoleBaseTemplate(dataObject, type);
        } else if (type === 'templateDetails') {
            dataObject = {
                "lang": ExtraInfo['lang'],
                'id': ExtraInfo['id'],
                'view': null,
                'data_type': 'json',
                'template_type': ExtraInfo['message_type'],
                'requestFor': 'email_template_details',
                'request_type': 'POST',
            };
            // request to server for laoding data.
            emailTemplateList.loadRoleBaseTemplate(dataObject, type);
        } else if (type === 'saveTemplateDetails') {
            dataObject = {
                "lang": ExtraInfo['lang'],
                'id': ExtraInfo['id'],
                'subject': ExtraInfo['subject'],
                'content': ExtraInfo['content'],
                'view': null,
                'requestFor': 'saveTemplate',
                'data_type': 'json',
                'template_type': ExtraInfo['message_type'],
                'request_type': 'POST',
            };
            emailTemplateList.loadRoleBaseTemplate(dataObject, type, function () {
                window.location.reload();
            });
        }

    };

    // load role base template.
    static loadRoleBaseTemplate = (dataObject, type, CallBackFunction = null) => {
        $.ajax({
            method: dataObject.request_type,
            data: dataObject,
            url: $('span.route').attr('data-route'),
            success: function (data) {
                emailTemplateList.afterServerRequest(data, type);
                if (typeof CallBackFunction === 'function') {
                    CallBackFunction(data);
                }
            },
            error: function (err, err2, err3) {
                BaseFile.invalidAjaxRequest(err);
            }
        });
    };

    // when ajax request, after this response is handling from here..
    static afterServerRequest = (dataObject, requestType) => {
        if (requestType === 'dropdown') {
            // add dropdown html
            $(selectEmailTemplateListDropdownMainDiv).html(dataObject);
            select_initializer.simpleSelect2('.kt_select2_5', 'Select a Email template');
            // set content of current template selected in dropdown.
            emailTemplateList.setMessageContent(emailTemplateList.getSelectedTemplateContentTranslation());
            // set subject of current template.
            emailTemplateList.setSubject(emailTemplateList.getSelectedTemplateSubjectTranslation());
        } else if (requestType == 'templateDetails') {
            // set template content.
            tinyMCE.get(emailTemplateList.getActiveTinyMce()).setContent(dataObject.content);
            // set email subject.
            $(templateSubjectInput).val(dataObject.subject);
        } else {
            BaseFile.handleRemoteAjaxResponse(dataObject);
        }
    };

    // before getting template details use this function.
    // i made this function because the same porceedure is used when clicking on template list dropdown & when clicking on the given translation list.
    // User pre_ajax function instead of this if you're not using above mentione functions.
    static beforePreAjax = (translateIn, templateId, actionType = 'details') => {

        if (isEmpty(translateIn)) {
            translateIn = 'en';
        }
        if (isEmpty(templateId)) {
            return console.log('Invalid template id');
        }
        // if we found template id then porceed.
        let ExtraInfo = {
            'id': templateId,
            'lang': translateIn,
            'message_type': emailTemplateList.getTemplateType(),
        };
        emailTemplateList.pre_ajax('templateDetails', ExtraInfo);
    };


    /*
    * Get & setter of remote request response.
    * when we're selecting an category of email template then email templates are loaded in the dropdown then first selected template also laod so this getter and setter will make it usaable.
    * */
    static getSelectedTemplateSubjectTranslation = () => {
        return $(s___remote_r).text();
    };

    static getSelectedTemplateContentTranslation = () => {
        return $(c___remote_r).text();
    };

    /*
    * set & getting templates type
    * we are using two type of templates, so, we have to extract what type of template we need so we are using this function to get the selected/visible template type.
    * */

    // getting.
    static getTemplateType = () => {
        return $('input[name=message_type]').val();
    };

    // setting.
    static setTemplateType = (value) => {
        $('input[name=message_type]').val(value);
    };


    /*
    * set & getting templates type
    * we are using two type of templates, so, we have to extract what type of template we need so we are using this function to get the selected/visible template type.
    * */

    //==getting Subject
    static getSubject = () => {
        return $('input[name=email_subject]').val();
    };

    // setting Subject
    static setSubject = (value) => {
        $('input[name=email_subject]').val(value);
    };

    //==getting Message Content
    static getMessageContent = () => {
        return tinyMCE.get('template_messages').getContent();
    };

    // setting Message Content
    static setMessageContent = (value) => {
        tinyMCE.get('template_messages').setContent(value)
    };

    //==getting Short Message Content
    static getShortMessageContent = () => {
        return tinyMCE.get('template_short_messages').getContent();
    };

    // setting Short Message Content
    static setShortMessageContent = (value) => {
        tinyMCE.get('template_short_messages').setContent(value)
    };

    /*
    * get the active template, content box.
    * */
    static getActiveTinyMce = () => {
        let value = '';
        if (emailTemplateList.getTemplateType() === 'detail_notification') {
            // detail email template view is visible
            value = 'template_messages';
        } else {
            // short email template view visible.
            value = 'template_short_messages';
        }
        return value;
    };

    // get the selected email tempalte id.
    static getSelectedTemplate = () => {
        return $(selectEmailTemplateDropDown).val();
    };


    /*
    * get default language.
    * */
    static getLang = () => {
        let lang = $(CurrentEditableLang).attr('data-lang');
        if (isEmpty(lang)) {
            lang = 'en';
        }
        return lang;
    }

}


// when class is initialized.
$(function () {
    // initialize page.
    emailTemplateList.Initialize();

    // load translated template.
    $(document).on('click', translationListLi, function (e) {
        e.preventDefault();
        emailTemplateList.updateTemplateInOtherLanguage($(this));
        // pass data to get the langugae..
        emailTemplateList.beforePreAjax(emailTemplateList.getLang(), emailTemplateList.getSelectedTemplate());
    });

    // tabs changer
    $(document).on('click', emailTemplateTabChangerLis, function (e) {
        e.preventDefault();
        emailTemplateList.tabChanger($(this));
    });

    // when someone selecting an email templates.
    $(document).on('change', selectEmailTemplateDropDown, function () {
        let templateId = $(this).val();
        let translateIn = emailTemplateList.getLang();
        emailTemplateList.beforePreAjax(translateIn, templateId);

        // selected template id in the variable
        selectedTemplateId = templateId;
    });

    // Save all data of detail message.
    $(document).on('click', detailMessageSaveButton, function (e) {
        e.preventDefault();
        let templateContent = null;

        if (emailTemplateList.getTemplateType() == 'detail_notification') {
            // if trying to adding email template

            if (isEmpty(emailTemplateList.getSubject())) {
                // if message subject is empty
                return BaseFile.showErrors('Please type valid email subject');
            }

            if (isEmpty(emailTemplateList.getMessageContent())) {
                // if message content is empty
                return BaseFile.showErrors('Please type some message before saving into the template.');
            } else {
                templateContent = emailTemplateList.getMessageContent();
            }
        } else {
            //  user is trying to add short email template e.g messages.
            if (isEmpty(emailTemplateList.getShortMessageContent())) {
                // if message content is empty
                return BaseFile.showErrors('Please type some message before saving into the template.');
            } else {
                templateContent = emailTemplateList.getShortMessageContent();
            }
        }


        // pass data to get the translations.
        let ExtraInfo = {
            'id': emailTemplateList.getSelectedTemplate(),
            'lang': emailTemplateList.getLang(),
            'message_type': emailTemplateList.getTemplateType(),
            'subject': emailTemplateList.getSubject(),
            'content': templateContent,
        };
        emailTemplateList.pre_ajax('saveTemplateDetails', ExtraInfo);
    });

    // changing nav menus, template type, detailed message or short messages.
    $(document).on('click', emailTemplateMessageType, function (e) {
        e.preventDefault();
        // get the template type.
        emailTemplateList.setTemplateType($(this).attr('data-type'));
        // pass data to get the translations.
        emailTemplateList.beforePreAjax(emailTemplateList.getLang(), emailTemplateList.getSelectedTemplate());
    });

    // enable disable email templates.
    $(document).on('change', 'input[name=notificationChanger]', function () {
        let thiss = $(this);
        let notificationType = $(thiss).attr('data-type');
        let checkBoxState = $(thiss).is(":checked");
        if (isEmpty(notificationType)) {
            // if missing then throw an error
            return BaseFile.showErrors('Configuration is missing');
        }
        // show loader
        DashBoard.showLoader();
        let Object = {
            id: $(thiss).closest('tr').attr('data-abide'),
            notificationType: notificationType,
            requestFor: 'updateEmailTemplateActiveInActiveStatus',
            request_type: 'POST',
        };
        emailTemplateList.loadRoleBaseTemplate(Object, 'updateEmailTemplateActiveInActiveStatus', function (serverResponse) {
            DashBoard.removeLoader();
        });
    });
});
