<?php


namespace App\Service\EmailSettings;


use App\Service\AppSettings;
use App\Service\DefaultFunction;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Csrf\TokenStorage\TokenStorageInterface;

class Settings extends DefaultFunction
{

    /**
     * @var AppSettings
     */
    private $app_settings;

    public function __construct(AppSettings $app_settings, RouterInterface $router, TokenStorageInterface $token_storage, ParameterBagInterface $parameter_bag)
    {
        parent::__construct($app_settings, $router, $token_storage, $parameter_bag);
        $this->app_settings = $app_settings;
    }


    /**
     * @return string|null
     *  Purpose: Set Mail url inside the .env file.
     */
    public function setMailURL()
    {
        $vendor = $this->getMailVendor();
        $response = null;
        if ($vendor == 'google') {
            $response = $this->setGoogleMailURL();
        } else {
            $response = $this->setSMTPMailURL();
        }

        return $response;
    }

    /**
     * @return mixed|string
     */
    public function getMailVendor()
    {
        return $this->app_settings->getAppSettingsFromSessions('email_vendor');
    }

    /**
     * @return string
     * Purpose: Set Google mail url
     */
    public function setGoogleMailURL()
    {
        $mailURl = 'gmail://' . $this->app_settings->getAppSettingsFromSessions('smtp_username') . ':' . $this->app_settings->getAppSettingsFromSessions('smtp_password') . '@' . $this->app_settings->getAppSettingsFromSessions('smtp_host') . '?encryption=' . $this->app_settings->getAppSettingsFromSessions('smtp_secure') . '&auth_mode=oauth';
        putenv('MAILER_URL=' . $mailURl);

        return $mailURl;
    }

    public function setSMTPMailURL()
    {
        $mailURl = 'smtp://' . $this->app_settings->getAppSettingsFromSessions('smtp_username') . ':' . $this->app_settings->getAppSettingsFromSessions('smtp_password') . '@' . $this->app_settings->getAppSettingsFromSessions('smtp_host') . ':' . $this->app_settings->getAppSettingsFromSessions('smtp_port');
        putenv('MAILER_URL=' . $mailURl);
        putenv('MAILER_DSN=' . $mailURl);
        return $mailURl;
    }


    /**
     * @return mixed|string
     */
    public function getMessageSentFromEmail()
    {
        $response = $this->app_settings->getAppSettingsFromSessions('from_email');
        if (!filter_var($response, FILTER_VALIDATE_EMAIL)) {
            $response = 'fekara@fekara.net';
        }

        return $response;
    }


    /**
     * @return mixed|string
     */
    public function getMessageSentFromName()
    {
        $response = $this->app_settings->getAppSettingsFromSessions('from_name');
        if (empty($response)) {
            $response = 'Fekara';
        }

        return $response;

    }

}