<?php

namespace App\Repository;

use App\Entity\ClassSubject;
use App\Entity\ClassSubjectTemplate;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method ClassSubject|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassSubject|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassSubject[]    findAll()
 * @method ClassSubject[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassSubjectRepository extends ServiceEntityRepository
{

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassSubject::class);
    }

    ## get subjects
    ## by the reference of class.
    public function getSubjects(int $classId)
    {
        return $this->createQueryBuilder('class_subject')
            ->leftJoin('class_subject.classes__', 'classes')
            ->andWhere('classes.id = :class_id')
            ->andWhere('class_subject.is_deleted = 0')
            ->setParameter('class_id', $classId)
            ->getQuery()
            ->getResult();
    }


    /**
     * @param bool $parse__YesNoToBoolean
     * PURPOSE: List of Class Subject.
     * @param ParameterBag|null $bag
     * @return mixed
     */
    public function listOfClassSubject(bool $parse__YesNoToBoolean, ParameterBag $bag = null)
    {
        ## Class Subjects query builder
        $queryBuilder = $this->createQueryBuilder('class_subject');
        $queryBuilder->leftJoin('class_subject.classes__', 'classes')->addSelect('classes');
        $queryBuilder->leftJoin(
            'class_subject.allocateTeacherToClassAndSubjects',
            'allocateTeacherToClassAndSubjects'
        )->addSelect('allocateTeacherToClassAndSubjects');
        $queryBuilder->leftJoin(
            'class_subject.class_session_enrolment_subject',
            'classSessionEnrolmentSubject'
        )->addSelect('classSessionEnrolmentSubject');

        if ($bag instanceof ParameterBag) {
            ## session filter
            if ($bag->get('session')) {
                $queryBuilder->andWhere('classes.session = :sessionParam')->setParameter(
                    'sessionParam',
                    $bag->get('session')
                );
            }

            ##  class filter
            if ($bag->get('class')) {
                $queryBuilder->andWhere('class_subject.classes__ = :classParam')->setParameter(
                    'classParam',
                    $bag->get('class')
                );
            }
        }
        ## ignore delete records
        if (!$parse__YesNoToBoolean) {
            $queryBuilder = $queryBuilder->andWhere('class_subject.is_deleted = :isDeletedParam')->setParameter(
                'isDeletedParam',
                0
            );
        }

        return $queryBuilder->orderBy('class_subject.is_deleted', 'ASC')->getQuery()->getResult();
    }


}

