<?php

namespace App\Repository;

use App\Entity\ClassFeeTemplate;
use App\Entity\ClassSubjectTemplate;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method ClassFeeTemplate|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassFeeTemplate|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassFeeTemplate[]    findAll()
 * @method ClassFeeTemplate[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassFeeTemplateRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassFeeTemplate::class);
    }

    ## duplication check
    public function duplicationCheck(ParameterBag $bag)
    {
        $queryBuilder = $this->createQueryBuilder('class_fee_template');

        if (!empty($bag->get('fee_id'))) {
            $queryBuilder->andWhere('class_fee_template.fee = :subjectRef')->setParameter('subjectRef', $bag->get('fee_id'));
        }

        if (!empty($bag->get('classTemplate_id'))) {
            $queryBuilder->andWhere('class_fee_template.class_template = :classTemplateRef')->setParameter('classTemplateRef', $bag->get('classTemplate_id'));
        }

        $queryBuilder->andWhere('class_fee_template.is_deleted = false');
        $response = $queryBuilder->getQuery()->getResult();
        return $response;

    }

    ## bulk duplication check
    public function bulkDuplicationCheck(array $fees, int $classTemplateId)
    {
        foreach ($fees as $key => $value) {
            $bag = new ParameterBag();
            $bag->set('fee_id', $value);
            $bag->set('classTemplate_id', $classTemplateId);
            $response = $this->duplicationCheck($bag);
            if (!empty($response)) {
                unset($fees[$key]);
            }
        }

        return $fees;
    }
}
