<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\LibraryBooksCategoryRepository")
 */
class LibraryBooksCategory
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $cat_name;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\BooksLibrary", mappedBy="book_cat_ref")
     */
    private $attached_books;

    public function __construct()
    {
        $this->attached_books = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCatName(): ?string
    {
        return $this->cat_name;
    }

    public function setCatName(string $cat_name): self
    {
        $this->cat_name = $cat_name;

        return $this;
    }

    /**
     * @return Collection|BooksLibrary[]
     */
    public function getAttachedBooks(): Collection
    {
        return $this->attached_books;
    }

    public function addAttachedBook(BooksLibrary $attachedBook): self
    {
        if (!$this->attached_books->contains($attachedBook)) {
            $this->attached_books[] = $attachedBook;
            $attachedBook->setBookCatRef($this);
        }

        return $this;
    }

    public function removeAttachedBook(BooksLibrary $attachedBook): self
    {
        if ($this->attached_books->contains($attachedBook)) {
            $this->attached_books->removeElement($attachedBook);
            // set the owning side to null (unless already changed)
            if ($attachedBook->getBookCatRef() === $this) {
                $attachedBook->setBookCatRef(null);
            }
        }

        return $this;
    }
}
