<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InventoryItemsUsageRepository")
 */
class InventoryItemsUsage {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InventoryStockLocation", inversedBy="inventoryItemsUsages")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $inv_item_usage_location;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InvtStockItems", inversedBy="inventoryItemsUsages")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $inventory__stock__item;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InventoryStock", inversedBy="inventoryItemsUsages")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $inventory__stock;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $issue_date;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	private $return_date;

	/**
	 * @ORM\Column(type="smallint")
	 */
	private $qty_given;

	public function getId(): ?int {
		return $this->id;
	}

	public function getInvItemUsageLocation(): ?InventoryStockLocation {
		return $this->inv_item_usage_location;
	}

	public function setInvItemUsageLocation( ?InventoryStockLocation $inv_item_usage_location ): self {
		$this->inv_item_usage_location = $inv_item_usage_location;

		return $this;
	}

	public function getInventoryStockItem(): ?InvtStockItems {
		return $this->inventory__stock__item;
	}

	public function setInventoryStockItem( ?InvtStockItems $inventory__stock__item ): self {
		$this->inventory__stock__item = $inventory__stock__item;

		return $this;
	}

	public function getInventoryStock(): ?InventoryStock {
		return $this->inventory__stock;
	}

	public function setInventoryStock( ?InventoryStock $inventory__stock ): self {
		$this->inventory__stock = $inventory__stock;

		return $this;
	}

	public function getIssueDate(): ?\DateTimeInterface {
		return $this->issue_date;
	}

	public function setIssueDate( \DateTimeInterface $issue_date ): self {
		$this->issue_date = $issue_date;

		return $this;
	}

	public function getReturnDate(): ?\DateTimeInterface {
		return $this->return_date;
	}

	public function setReturnDate( ?\DateTimeInterface $return_date ): self {
		$this->return_date = $return_date;

		return $this;
	}

	public function getQtyGiven(): ?int {
		return $this->qty_given;
	}

	public function setQtyGiven( int $qty_given ): self {
		$this->qty_given = $qty_given;

		return $this;
	}
}
