<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InternalChatGroupUsersRepository")
 */
class InternalChatGroupUsers {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InternalChatGroups", inversedBy="internalChatGroupUsers")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $icg;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="internal_chat_group_user__involved")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $involved_users;

	public function getId(): ?int {
		return $this->id;
	}

	public function getIcg(): ?InternalChatGroups {
		return $this->icg;
	}

	public function setIcg( ?InternalChatGroups $icg ): self {
		$this->icg = $icg;

		return $this;
	}

	public function getInvolvedUsers(): ?User {
		return $this->involved_users;
	}

	public function setInvolvedUsers( ?User $involved_users ): self {
		$this->involved_users = $involved_users;

		return $this;
	}
}
