<?php

namespace App\Entity;

use App\Repository\EmailTemplateEventsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ExamsRepository")
 */
class Exams
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $exam_name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $exam_details;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClasses", mappedBy="exam")
     */
    private $examsClasses;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->examsClasses = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getExamName(): ?string
    {
        return $this->exam_name;
    }

    public function setExamName(string $exam_name): self
    {
        $this->exam_name = $exam_name;

        return $this;
    }

    public function getExamDetails(): ?string
    {
        return $this->exam_details;
    }

    public function setExamDetails(?string $exam_details): self
    {
        $this->exam_details = $exam_details;

        return $this;
    }

    /**
     * @return Collection|ExamsClasses[]
     */
    public function getExamsClasses(): Collection
    {
        return $this->examsClasses;
    }

    public function addExamsClass(ExamsClasses $examsClass): self
    {
        if (!$this->examsClasses->contains($examsClass)) {
            $this->examsClasses[] = $examsClass;
            $examsClass->setExam($this);
        }

        return $this;
    }

    public function removeExamsClass(ExamsClasses $examsClass): self
    {
        if ($this->examsClasses->contains($examsClass)) {
            $this->examsClasses->removeElement($examsClass);
            // set the owning side to null (unless already changed)
            if ($examsClass->getExam() === $this) {
                $examsClass->setExam(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

}
