<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassTemplateRepository")
 */
class ClassTemplate
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=40)
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    private $short_name;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $attendance_type;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $active;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $no_of_students;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $fee;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $subjectwise_fee;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSubjectTemplate", mappedBy="class_template__")
     */
    private $classSubjectTemplates;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Classes", mappedBy="class_template", orphanRemoval=true)
     */
    private $Classes;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFeeTemplate", mappedBy="class_template")
     */
    private $classFeeTemplates;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassGradeTemplate", mappedBy="class_template")
     */
    private $classGradeTemplates;


    public function __construct()
    {
        $this->classSubjectTemplates = new ArrayCollection();
        $this->Classes = new ArrayCollection();
        $this->classFeeTemplates = new ArrayCollection();
        $this->classGradeTemplates = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getShortName(): ?string
    {
        return $this->short_name;
    }

    public function setShortName(?string $short_name): self
    {
        $this->short_name = $short_name;

        return $this;
    }

    public function getAttendanceType(): ?int
    {
        return $this->attendance_type;
    }

    public function setAttendanceType(int $attendance_type): self
    {
        $this->attendance_type = $attendance_type;

        return $this;
    }

    public function getActive(): ?int
    {
        return $this->active;
    }

    public function setActive(int $active): self
    {
        $this->active = $active;

        return $this;
    }

    public function getNoOfStudents(): ?int
    {
        return $this->no_of_students;
    }

    public function setNoOfStudents(?int $no_of_students): self
    {
        $this->no_of_students = $no_of_students;

        return $this;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function setFee(?float $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    public function getSubjectwiseFee(): ?int
    {
        return $this->subjectwise_fee;
    }

    public function setSubjectwiseFee(?int $subjectwise_fee): self
    {
        $this->subjectwise_fee = $subjectwise_fee;

        return $this;
    }

    /*
     * @deprecated, this code in result of merge : 25-07-2019
     * @return Collection|ClassSubjectTemplate[]
     */
    /*	public function getClassSubjectTemplates(): Collection {
            return $this->classSubjectTemplates;
        }

        public function addClassSubjectTemplate( ClassSubjectTemplate $classSubjectTemplate ): self {
            if ( ! $this->classSubjectTemplates->contains( $classSubjectTemplate ) ) {
                $this->classSubjectTemplates[] = $classSubjectTemplate;
                $classSubjectTemplate->addClassTemplate( $this );
            }

            return $this;
        }

        public function removeClassSubjectTemplate( ClassSubjectTemplate $classSubjectTemplate ): self {
            if ( $this->classSubjectTemplates->contains( $classSubjectTemplate ) ) {
                $this->classSubjectTemplates->removeElement( $classSubjectTemplate );
                $classSubjectTemplate->removeClassTemplate( $this );
            }

            return $this;
        }*/

    /**
     * @return Collection|Classes[]
     */
    public function getClasses(): Collection
    {
        return $this->Classes;
    }

    public function addClass(Classes $class): self
    {
        if (!$this->Classes->contains($class)) {
            $this->Classes[] = $class;
            $class->setClassTemplate($this);
        }

        return $this;
    }

    public function removeClass(Classes $class): self
    {
        if ($this->Classes->contains($class)) {
            $this->Classes->removeElement($class);
            // set the owning side to null (unless already changed)
            if ($class->getClassTemplate() === $this) {
                $class->setClassTemplate(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassSubjectTemplate[]
     */
    public function getClassSubjectTemplates(): Collection
    {
        return $this->classSubjectTemplates;
    }

    public function addClassSubjectTemplate(ClassSubjectTemplate $classSubjectTemplate): self
    {
        if (!$this->classSubjectTemplates->contains($classSubjectTemplate)) {
            $this->classSubjectTemplates[] = $classSubjectTemplate;
            $classSubjectTemplate->addClassTemplate($this);
        }

        return $this;
    }

    public function removeClassSubjectTemplate(ClassSubjectTemplate $classSubjectTemplate): self
    {
        if ($this->classSubjectTemplates->contains($classSubjectTemplate)) {
            $this->classSubjectTemplates->removeElement($classSubjectTemplate);
            $classSubjectTemplate->removeClassTemplate($this);
        }

        return $this;
    }

    /**
     * @return Collection|ClassFeeTemplate[]
     */
    public function getClassFeeTemplates(): Collection
    {
        return $this->classFeeTemplates;
    }

    public function addClassFeeTemplate(ClassFeeTemplate $classFeeTemplate): self
    {
        if (!$this->classFeeTemplates->contains($classFeeTemplate)) {
            $this->classFeeTemplates[] = $classFeeTemplate;
            $classFeeTemplate->setClassTemplate($this);
        }

        return $this;
    }

    public function removeClassFeeTemplate(ClassFeeTemplate $classFeeTemplate): self
    {
        if ($this->classFeeTemplates->contains($classFeeTemplate)) {
            $this->classFeeTemplates->removeElement($classFeeTemplate);
            // set the owning side to null (unless already changed)
            if ($classFeeTemplate->getClassTemplate() === $this) {
                $classFeeTemplate->setClassTemplate(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    /**
     * @return Collection|ClassGradeTemplate[]
     */
    public function getClassGradeTemplates(): Collection
    {
        return $this->classGradeTemplates;
    }

    public function addClassGradeTemplate(ClassGradeTemplate $classGradeTemplate): self
    {
        if (!$this->classGradeTemplates->contains($classGradeTemplate)) {
            $this->classGradeTemplates[] = $classGradeTemplate;
            $classGradeTemplate->setClassTemplate($this);
        }

        return $this;
    }

    public function removeClassGradeTemplate(ClassGradeTemplate $classGradeTemplate): self
    {
        if ($this->classGradeTemplates->contains($classGradeTemplate)) {
            $this->classGradeTemplates->removeElement($classGradeTemplate);
            // set the owning side to null (unless already changed)
            if ($classGradeTemplate->getClassTemplate() === $this) {
                $classGradeTemplate->setClassTemplate(null);
            }
        }

        return $this;
    }

}
