<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassSessionEnrolmentFeeScheduleRepository")
 */
class ClassSessionEnrolmentFeeSchedule {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=60)
	 */
	private $csefs_title;

	/**
	 * @ORM\Column(type="float")
	 */
	private $csefs_amount;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	private $csefs_due_date;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	private $csefs_last_due_date;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $csefs_generation_date;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $csefs_last_process_date;

	/**
	 * @ORM\Column(type="smallint")
	 */
	private $process;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\Invoices", inversedBy="classSessionEnrolmentFeeSchedules")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $invoice;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\ClassSessionEnrolment", inversedBy="classSessionEnrolmentFeeSchedules")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $class_session_enrolment;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\ClassFee", inversedBy="classSessionEnrolmentFeeSchedules")
	 * @ORM\JoinColumn(nullable=true)
	 */
	private $fee;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

	public function getId(): ?int {
         		return $this->id;
         	}

	public function getCsefsTitle(): ?string {
         		return $this->csefs_title;
         	}

	public function setCsefsTitle( string $csefs_title ): self {
         		$this->csefs_title = $csefs_title;
         
         		return $this;
         	}

	public function getCsefsAmount(): ?float {
         		return $this->csefs_amount;
         	}

	public function setCsefsAmount( float $csefs_amount ): self {
         		$this->csefs_amount = $csefs_amount;
         
         		return $this;
         	}

	public function getCsefsDueDate(): ?\DateTimeInterface {
         		return $this->csefs_due_date;
         	}

	public function setCsefsDueDate( ?\DateTimeInterface $csefs_due_date ): self {
         		$this->csefs_due_date = $csefs_due_date;
         
         		return $this;
         	}

	public function getCsefsLastDueDate(): ?\DateTimeInterface {
         		return $this->csefs_last_due_date;
         	}

	public function setCsefsLastDueDate( ?\DateTimeInterface $csefs_last_due_date ): self {
         		$this->csefs_last_due_date = $csefs_last_due_date;
         
         		return $this;
         	}

	public function getCsefsGenerationDate(): ?\DateTimeInterface {
         		return $this->csefs_generation_date;
         	}

	public function setCsefsGenerationDate( \DateTimeInterface $csefs_generation_date ): self {
         		$this->csefs_generation_date = $csefs_generation_date;
         
         		return $this;
         	}

	public function getCsefsLastProcessDate(): ?\DateTimeInterface {
         		return $this->csefs_last_process_date;
         	}

	public function setCsefsLastProcessDate( \DateTimeInterface $csefs_last_process_date ): self {
         		$this->csefs_last_process_date = $csefs_last_process_date;
         
         		return $this;
         	}

	public function getProcess(): ?int {
         		return $this->process;
         	}

	## 1 mean schedule is generated
	public function setProcess( int $process ): self {
         		$this->process = $process;
         
         		return $this;
         	}

	public function getInvoice(): ?Invoices {
         		return $this->invoice;
         	}

	public function setInvoice( ?Invoices $invoice ): self {
         		$this->invoice = $invoice;
         
         		return $this;
         	}

	public function getClassSessionEnrolment(): ?ClassSessionEnrolment {
         		return $this->class_session_enrolment;
         	}

	public function setClassSessionEnrolment( ?ClassSessionEnrolment $class_session_enrolment ): self {
         		$this->class_session_enrolment = $class_session_enrolment;
         
         		return $this;
         	}

	public function getFee(): ?ClassFee {
         		return $this->fee;
         	}

	public function setFee( ?ClassFee $fee ): self {
         		$this->fee = $fee;
         
         		return $this;
         	}

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

}
