var Encore = require('@symfony/webpack-encore');

// Manually configure the runtime environment if not already configured yet by the "encore" command.
// It's useful when you use tools that rely on webpack.config.js file.
if (!Encore.isRuntimeEnvironmentConfigured()) {
    Encore.configureRuntimeEnvironment(process.env.NODE_ENV || 'dev');
}

Encore
// directory where compiled assets will be stored
    .setOutputPath('fekara/build2/')
    // public path used by the web server to access the output path
    .setPublicPath('/build2')
    // only needed for CDN's or sub-directory deploy
    //.setManifestKeyPrefix('build/')

    /*
     * ENTRY CONFIG
     *
     * Add 1 entry for each "page" of your app
     * (including one that's included on every page - e.g. "app")
     *
     * Each entry will result in one JavaScript file (e.g. app.js)
     * and one CSS file (e.g. app.css) if your JavaScript imports CSS.
     */
    .addEntry('mainJs', './assets/js/base.ts')
    .addEntry('addCustomFields', './assets/js/CustomFields/addNewField.ts')
    .addEntry('viewCustomFields', './assets/js/CustomFields/index.ts')
    .addEntry('select2__init', './assets/js/libraries/select2.ts')
    .addEntry('dateRangepicker__init', './assets/js/libraries/dateRangePicker.ts')
    .addEntry('datePicker__init', './assets/js/libraries/datepicker.ts')
    .addEntry('emailTemplates', './assets/js/email_templates/index.ts')
    .addEntry('appSettings', './assets/js/app_settings/index.ts')
    .addEntry('usersProfile', './assets/js/user/index.ts')
    .addEntry('guardian', './assets/js/guardian/index.ts')
    .addEntry('datePicker', './assets/js/libraries/datepicker.ts')
    .addEntry('sessions', './assets/js/sessions/sessions.ts')
    .addEntry('classes', './assets/js/classes/index.ts')
    .addEntry('classTimeTable', './assets/js/classes/timeTable.ts')
    .addEntry('studentFee', './assets/js/fees/studentFee.ts')
    .addEntry('subjects', './assets/js/subjects/subjects.ts')
    .addEntry('attendance', './assets/js/attendance/index.ts')
    .addEntry('internalChat', './assets/js/InternalChat/index.ts')
    .addEntry('internalChatWebSocket', './assets/js/InternalChat/webscocket__c.ts')
    .addEntry('book_library', './assets/js/book_library/book_library.ts')
    .addEntry('school_inventory', './assets/js/inventory/inventory.ts')
    .addEntry('accounts', './assets/js/accounts/accounts.ts')
    .addEntry('exams', './assets/js/exams/exams.ts')
    .addEntry('registration', './assets/js/security/registration.ts')
    .addEntry('UserList', './assets/js/user/UsersList.ts')
    .addEntry('inbox', './assets/js/InternalChat/inbox.ts')
    .addEntry('student', './assets/js/students/index.ts')
    .addEntry('studentAssessment', './assets/js/students/assessment.ts')
    .addEntry('teacher', './assets/js/user/teacher/index.ts')
    .addEntry('pdfRe portingSettings', './assets/js/app_settings/pdfReporting.ts')
    .addEntry('dateRangePicker', './assets/js/libraries/dateRangePicker.ts')
    .addEntry('scheduleMessages', './assets/js/scheduleMesage/base.ts')
    .addEntry('studentGrade', './assets/js/students/grade.ts')
    .addStyleEntry('ChatStyleSheet', './assets/css/InternalChat/chat.css')

    // When enabled, Webpack "splits" your files into smaller pieces for greater optimization.
    .splitEntryChunks()

    // will require an extra script tag for runtime.js
    // but, you probably want this, unless you're building a single-page app
    .enableSingleRuntimeChunk()

    /*
     * FEATURE CONFIG
     *
     * Enable & configure other features below. For a full
     * list of features, see:
     * https://symfony.com/doc/current/frontend.html#adding-more-features
     */
    .cleanupOutputBeforeBuild()
    .enableBuildNotifications()
    //.enableBuildNotifications()
    .enableSourceMaps(!Encore.isProduction())
    // enables hashed filenames (e.g. app.abc123.css)
    .enableVersioning(Encore.isProduction())

    // enables @babel/preset-env polyfills
    .configureBabel(() => {
    }, {
        useBuiltIns: 'usage',
        corejs: 3
    })

    // enables Sass/SCSS support
    .enableSassLoader()

    // uncomment if you use TypeScript
    .enableTypeScriptLoader()

    // uncomment to get integrity="..." attributes on your script & link tags
    // requires WebpackEncoreBundle 1.4 or higher
    //.enableIntegrityHashes(Encore.isProduction())

    // uncomment if you're having problems with a jQuery plugin
    .autoProvidejQuery({
        $: 'jquery',
        jQuery: 'jquery',
        'window.jQuery': 'jquery',
    });

// uncomment if you use API Platform Admin (composer req api-admin)
//.enableReactPreset()
//.addEntry('admin', './assets/js/admin.js')

module.exports = Encore.getWebpackConfig();
