<?php


namespace App\Service\accounts;


use App\Entity\User;
use App\Service\DefaultFunction;
use Symfony\Component\HttpFoundation\FileBag;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class PaymentsService
{


    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var InvoiceService
     */
    private $invoice_service;
    /**
     * @var TransactionService
     */
    private $transaction_service;
    /**
     * @var TokenStorage
     */
    private $token_storage;

    public function __construct(DefaultFunction $default_function, InvoiceService $invoice_service, TransactionService $transaction_service, TokenStorageInterface $token_storage)
    {
        $this->default_function = $default_function;
        $this->invoice_service = $invoice_service;
        $this->transaction_service = $transaction_service;
        $this->token_storage = $token_storage;
    }


    ## validate payment
    public function validatePayMent(ParameterBag $request)
    {
        $resposne = [];
        ## empty invoice and transaction amount
        if (empty($request->get('trans__am'))) {
            $resposne = $this->default_function->push_error($resposne, 'Amount is missing');
        }

        return $resposne;
    }


    /**
     * @param ParameterBag $request
     * @param FileBag $filebag
     * add_edit payment
     * payment is combination of two entites 1 is Invoice and other is Transactions.
     *
     * @return array|mixed|string
     */
    public function add__update_payment(ParameterBag $request, FileBag $filebag)
    {

        ## if error then return the error.
        if (!empty($validatePayment = $this->validatePayMent($request))) {
            return $validatePayment;
        }

        ## save invoice first - because transaction is using invoice reference
        $p_bag = new ParameterBag();

        ## save user info - for which user this invoice is generated for.
        $p_bag->set('u____s', $request->get('u____s'));
        $p_bag->set('s__u_n', $request->get('s__u_n'));
        $p_bag->set('w__u_n', $request->get('w__u_n'));

        ## if we want to update the invoice.
        $p_bag->set('inv___ifID', $request->get('inv___iIF_fed'));

        ## invoice is generated by system
        $p_bag->set('in___gn__by', $request->get('s__u'));

        ## save system notes that invoice is generated by system.
        /** @var User $UserObj */
        $UserObj = $this->token_storage->getToken()->getUser();
        $p_bag->set('s___t', 'This invoice is generated by at the time of instant payment which is doing by ' . $UserObj->getFName() . ' ' . $UserObj->getLName() . ' with unique number  ' . $UserObj->getAdmissionNumber());

        ## save the payment method.
        $p_bag->set('p___mod', $request->get('trans__payM__ref'));

        ## invoice generation time.
        $p_bag->set('inv___g_t', $request->get('tran___dt'));

        ## invoice due date is automatically set to the today's date
        $p_bag->set('inv__ref', $request->get('inv___ref'));

        ## saving invoice items.
        ## save the invoice item description.
        ## if invoice description is not empty then save it in the invoice item description
        if (empty($request->get('tran___des'))) {
            ## if empty then save the system has generated description
            $p_bag->set('inv__it__des', [$p_bag->get('s___t')]);
        } else {
            ## if not then save the invoice description
            $p_bag->set('inv__it__des', [$request->get('tran___des')]);
        }

        ## save the invoice item amount.
        $p_bag->set('inv__it__am', [$request->get('trans__am')]);
        $p_bag->set('inv_it_ref__', [$request->get('inv_it_ref__')]);
        ## save the invoice user notes.
        $p_bag->set('u__n_t', $request->get('tran___n_t'));
        ## get last invoice added id
        $p_bag->set('getLastIDWithOKMessage', true);
        ## finally save invoice.
        $invoice__response = $this->invoice_service->add_edit_invoice($p_bag);
        ## adding system notes.
        $request->set('tran___n_t', $request->get('tran___n_t'));

        ## validate the service response - if invoices are save successfully then save transaction.
        if (is_string($invoice__response) && substr($invoice__response, 0, 2) == 'OK') {
            ## save invoice reference.
            $request->set('trans__inv_ref', substr($invoice__response, 2));
            ## save trans is income or expense - this is instant income.
            $request->set('trans___is_inc_exp', 2);
            ## save this is the instant payment
            $request->set('trans___instan_pay', 2);
            ## finally save transactions.
            $response = $this->transaction_service->_add_edit_transactions($request, $filebag);

            return $response;
        } else {
            return $invoice__response;
        }

    }


    ## get payment method.
    ## use in the accounts service.


}