<?php
/**
 * Created by PhpStorm.
 * User: bcsf1
 * Date: 8/21/2019
 * Time: 11:32 AM
 */

namespace App\Service;


use App\Entity\BooksLibrary;
use App\Entity\LibraryAssigned;
use App\Entity\LibraryBookCopies;
use App\Entity\LibraryBooksAuthor;
use App\Entity\LibrarySections;
use App\Entity\User;
use App\Repository\BooksLibraryRepository;
use App\Repository\LibraryAssignedRepository;
use App\Repository\LibraryBookCopiesRepository;
use App\Repository\LibraryBooksAuthorRepository;
use App\Repository\LibraryBooksCategoryRepository;
use App\Repository\LibrarySectionsRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use App\Entity\LibraryBooksCategory;
use Twig\Environment;

class LibraryService
{

    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var LibraryBooksCategoryRepository
     */
    private $library_books_category_repository;
    /**
     * @var $library_book_author_repository
     */
    private $library_books_author_repository;

    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;

    /**
     * @var Environment
     */
    Private $templating;
    /**
     * @var LibrarySectionsRepository
     */
    private $library_sections_repository;

    private $html___;
    /**
     * @var BooksLibraryRepository
     */
    private $books_library_repository;
    /**
     * @var LibraryBookCopiesRepository
     */
    private $library_book_copies_repository;
    /**
     * @var LibraryAssignedRepository
     */
    private $library_assigned_repository;
    /**
     * @var \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface
     */
    private $token_storage;
    /**
     * @var UserService
     */
    private $user_service;

    public function __construct(LibraryBookCopiesRepository $library_book_copies_repository, UserService $user_service, LibraryAssignedRepository $library_assigned_repository, BooksLibraryRepository $books_library_repository, LibraryBooksCategoryRepository $libraryBooksCategoryRepository, LibraryBooksAuthorRepository $library_books_author_repository, EntityManagerInterface $entityManager, DefaultFunction $defaultFunction, Environment $templating, LibrarySectionsRepository $library_sections_repository, \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface $token_storage)
    {
        $this->library_books_category_repository = $libraryBooksCategoryRepository;
        $this->library_books_author_repository = $library_books_author_repository;
        $this->entity_manager = $entityManager;
        $this->default_function = $defaultFunction;
        $this->templating = $templating;

        $this->library_sections_repository = $library_sections_repository;
        $this->books_library_repository = $books_library_repository;
        $this->library_book_copies_repository = $library_book_copies_repository;
        $this->library_assigned_repository = $library_assigned_repository;
        $this->token_storage = $token_storage;
        $this->user_service = $user_service;
    }


    /*
     * Library Category
     *
     * */


    /**
     * @param ParameterBag $bag
     * Purpose: validate add update category form
     */
    public function validate_add_edit_category(ParameterBag $bag)
    {
        $response = [];

        ## if category name is missing throw an error.
        if (empty($bag->get('category_name'))) {
            $response = $this->default_function->push_error($response, 'Please Type a Category Name');
        }

        return $response;
    }


    /**
     * @param ParameterBag $bag
     * purpose : add update category
     */
    public function add_edit_category(ParameterBag $bag)
    {
        $response = [];

        $validate__response = $this->validate_add_edit_category($bag);
        if (!empty($validate__response)) {
            return $validate__response;
        }

        ## deciding what to do, add or edit a category
        if (empty($bag->get('hiddenCategoryId'))) {
            ## add new category
            $bookCategory = new LibraryBooksCategory();
        } else {
            ## edit/update an existing category
            $bookCategory = $this->library_books_category_repository->find($bag->get('hiddenCategoryId'));
            ## book category is not found then create a new instance
            if (!$bookCategory instanceof LibraryBooksCategory) {
                $bookCategory = new LibraryBooksCategory();
            }
        }

        ## save the category name
        $bookCategory->setCatName($bag->get('category_name'));

        ## try to add in database.
        try {
            $this->entity_manager->persist($bookCategory);
            $this->entity_manager->flush();
            $response = 'escape__fromErro_' . $bookCategory->getId() . '_af_d_f_____' . $this->templating->render('library/book_category___list_view.html.twig', ['category_list' => [$bookCategory],]);
        } catch (\Exception $exception) {
            $response = $this->default_function->push_error($response, $exception->getMessage());

        }

        return $response;
    }


    ## get the book category
    public function get_the_book_cat(int $reference)
    {
        $response = null;

        if (!empty($reference)) {
            try {
                $response = $this->library_books_category_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    /*
     * Library Book Authors
     */

    public function validate_add_edit_books_author(ParameterBag $author_bag)
    {
        //Save new Book Author
        $response = [];

        if (empty($author_bag->get('author_name'))) {
            $response = $this->default_function->push_error($response, 'Please Type a Category Name');
        }

        return $response;
    }

    public function add_edit_book_author(ParameterBag $author_bag)
    {
        $response = [];

        $validate_author_response = $this->validate_add_edit_books_author($author_bag);
        if (!empty($validate_author_response)) {
            return $validate_author_response;
        }
        if (empty($author_bag->get('hiddenAuthorId'))) {
            $bookAuthor = new LibraryBooksAuthor();
        } else {
            $bookAuthor = $this->library_books_author_repository->find($author_bag->get('hiddenAuthorId'));
        }


        try {
            $bookAuthor->setAuthName($author_bag->get('author_name'));
            $bookAuthor->setAuthBiography($author_bag->get('author_biography'));
            $this->entity_manager->persist($bookAuthor);
            $this->entity_manager->flush();

            $response = 'escape__fromErro_' . $bookAuthor->getId() . '_af_d_f_____' . $this->templating->render('library/book_author__list_view.html.twig', ['author_list' => [$bookAuthor],]);
        } catch (\Exception $exception) {
            $response = $this->default_function->push_error($response, $exception->getMessage());
        }

        return $response;
    }


    ## get the book auth
    public function get_the_book_auth(int $reference)
    {
        $response = null;

        if (!empty($reference)) {
            try {
                $response = $this->library_books_author_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    /*
     * Library Sections
     *
     * */

    ## validate library sections.
    public function validate_library_sections(ParameterBag $request)
    {
        $response = [];

        ## if category name is missing throw an error.
        if (empty($request->get('ls_name'))) {
            $response = $this->default_function->push_error($response, 'Please Type a Section Name');
        }

        return $response;
    }

    ## add edit library sections.
    public function add_edit_library_sections(ParameterBag $request)
    {
        $response = [];

        ## validate the section form
        $validate__response = $this->validate_library_sections($request);
        if (!empty($validate__response)) {
            return $validate__response;
        }

        ## deciding what to do, add or edit a category
        $librarySection = null;
        if (!empty($request->get('____d__fe'))) {
            ## add new section
            try {
                ## edit/update an existing section
                $librarySection = $this->library_sections_repository->find($request->get('____d__fe'));
            } catch (\Exception $exception) {
                $response = $this->default_function->push_error($response, 'Failed to get the records from database.');
            }
        }

        ## book category is not found then create a new instance
        if (!$librarySection instanceof LibrarySections) {
            $librarySection = new LibrarySections();
        }


        ## if response not null then send back the user
        if (!empty($response)) {
            return $response;
        }

        ## save the section name
        $librarySection->setLsName($request->get('ls_name'));

        ## if parent top section is not sent by client
        if (!empty($request->get('parent_ls_name'))) {
            $librarySection__ = null;
            try {
                $librarySection__ = $this->library_sections_repository->find($request->get('parent_ls_name'));
            } catch (\Exception $exception) {
                $response = $this->default_function->push_error($response, 'Failed to get the records from database.');
            }

            ## book category is not found then create a new instance
            if ($librarySection__ instanceof LibrarySections) {
                $librarySection->setLsParent($request->get('parent_ls_name'));
            } else {
                $librarySection->setLsParent(0);
            }
        }


        ## try to add in database.
        try {

            ## save data in database
            $this->entity_manager->persist($librarySection);
            $this->entity_manager->flush();
            $response = 'OK';

            ## purify results.
//            $response['_data'] = 'escape__fromErro_' . $librarySection->getId() . '_af_d_f_____' . $this->templating->render('library/library_sections__list_view.html.twig', ['sections_list' => [$this->library_sections_repository->result_in_array($librarySection->getId())]]);
//            $response['list__of_sections'] = 'escape__fromErro_' . $this->templating->render('library/library_sections__list_drop_down_view.html.twig', [
//                    'sections_list' => $this->library_sections_repository->findAll(),
//                    'sections_list__tree_view' => $this->generate_html_from__tree_view($this->buildTree___view($this->library_sections_repository->result_in_array())),
//                ]);
//            $response['status'] = 'OK';

        } catch (\Exception $exception) {
            $response = $this->default_function->push_error($response, $exception->getMessage());

        }

        return $response;

    }

    ## build tree view
    function buildTree___view(array $elements, $parentId = 0)
    {
        $branch = array();

        foreach ($elements as $element) {
            if ($element['ls_parent'] == $parentId) {
                $children = $this->buildTree___view($elements, $element['id']);
                if ($children) {
                    $element['children'] = $children;
                }
                $branch[] = $element;
            }
        }

        return $branch;
        //return $branch;
    }

    ## generate html from the tree view array.
    function generate_html_from__tree_view($array, $html__val = null)
    {
        $html = '<ul>';

        foreach ($array as $value) {
            if (!empty($value['children'])) {
                $val___ = $this->generate_html_from__tree_view($value['children']);
                if ($val___) {
                    $html .= '<li data-ref=" ' . $value['id'] . ' " data-jstree=\'{ "opened" : true }\'> ' . $value ['ls_name'] . $val___ . '</li>';
                }

            } else {
                $html .= '<li data-ref=" ' . $value['id'] . ' "> ' . $value ['ls_name'] . '</li>';
            }
        }

        $html .= '</ul>';

        return $html;
    }

    ## get the library section
    public function get_the_library_sec(int $reference)
    {
        $response = null;
        if (!empty($reference)) {
            try {
                $response = $this->library_sections_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }


    /*
     * Book Library.
     *
     * */

    ## validate the form before saving books in the library.
    public function validate_books_library(ParameterBag $bag)
    {
        $response = [];

        ## if book name is missing throw an error.
        if (empty($bag->get('b___name'))) {
            $response = $this->default_function->push_error($response, 'Please Type a book name');
        }

        return $response;
    }

    ## add or update books in library
    public function add_update_books_in_library(ParameterBag $bag)
    {
        $response = [];

        $validation_response = $this->validate_books_library($bag);
        if (!empty($validation_response)) {
            return $validation_response;
        }

        $Entity = new BooksLibrary();

        ## decide edit or add a books in library.
        if (!empty($bag->get('____d__fe_rd'))) {
            try {
                $Entity = $this->books_library_repository->find($bag->get('____d__fe_rd'));
            } catch (\Exception $exception) {
                $Entity = new BooksLibrary();
            }
        }


        ## get the book category & set it if valid
        $category = $this->get_the_book_cat($bag->get('b___ct'));
        if ($category instanceof LibraryBooksCategory) {
            $Entity->setBookCatRef($category);
        } else {
            $response = $this->default_function->push_error($response, 'Book Category is not selected');
        }

        ## get the book author & set it if valid
        if (!empty($bag->get('b___a'))) {
            $auth = $this->get_the_book_auth($bag->get('b___a'));
            if ($auth instanceof LibraryBooksAuthor) {
                $Entity->setBookAuth($auth);
            }
        } else {
            $response = $this->default_function->push_error($response, 'Book Auth is not selected');
        }


        ## get the book section & set it if valid
        if (!empty($bag->get('b___sec'))) {
            $sec = $this->get_the_library_sec($bag->get('b___sec'));
            if ($sec instanceof LibrarySections) {
                $Entity->setLibrarySections($sec);
            }
        } else {
            $response = $this->default_function->push_error($response, 'Book Section is not selected');
        }

        ## if response is not empty then return the error collection.
        if (!empty($response)) {
            return $response;
        }


        $Entity->setBookName($bag->get('b___name'));
        $Entity->setBookDescription($bag->get('desc___book'));
        $Entity->setBookCost($bag->get('b___cost'));
        $Entity->setBookFinePerHour($bag->get('b___f_p_h'));
        $Entity->setBookDepositRequirement($bag->get('b__d___r'));

        try {
            $this->entity_manager->persist($Entity);
            $this->entity_manager->flush();
            $response = 'escape__fromErro_' . $Entity->getId() . '_af_d_f_____' . $this->templating->render('library/books_in_library__list_view.html.twig', [
                    'books__list' => [$Entity],
                    'book_copies' => $Entity->getLibraryBookCopies(),
                ]);
            $this->add_update_book_copies($Entity, $bag->get('b___c_no'), $bag->get('b___c_con'), $bag->get('b___c_ref'));
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;

    }

    ## get the books in the library
    public function get_the_books__in_library(int $reference)
    {
        $response = null;
        if (!empty($reference)) {
            try {
                $response = $this->books_library_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }


    /*
     * Books Copies.
     *
     * */
    public function validate__books_copies($Number)
    {
        $response = [];

        ## if book name is missing throw an error.
        if (empty($Number)) {
            $response = $this->default_function->push_error($response, 'Please type book copy number');
        }

        return $response;
    }


    ## save the library book copies.
    public function add_update_book_copies(BooksLibrary $LibraryBookRef, $BookCopyNumber = [], $BookCopyCondition = [], $BookCopyRef = [])
    {
        $response = '';

        for ($var = 0; $var < count($BookCopyNumber); $var++) {

            ## if book copy number is not given then ignore it.
            if (empty($BookCopyNumber[$var])) {
                continue;
            }

            ## if book condition is greater than 5 or lower than 1
            if (empty($BookCopyCondition[$var]) || $BookCopyCondition[$var] < 0) {
                $BookCopyCondition[$var] = 0;
            }

            ## if book condition is greater than 5 then consider it 5
            if ($BookCopyCondition[$var] > 5) {
                $BookCopyCondition[$var] = 5;
            }

            $Entity = null;
            try {
                $Entity = $this->library_book_copies_repository->find($BookCopyRef[$var]);
            } catch (\Exception $exception) {
            }


            if (!$Entity instanceof LibraryBookCopies) {
                $Entity = new LibraryBookCopies();
            }

            $Entity->setBcNo((int)$BookCopyNumber[$var]);
            $Entity->setBcConditionRating((int)$BookCopyCondition[$var]);
            $Entity->setLibraryBookRef($LibraryBookRef);
            $this->entity_manager->persist($Entity);
        }

        $this->entity_manager->flush();

        return $response;

    }


    ## get the books copy from the library
    public function get_the_books__copies__in_library(int $reference)
    {
        $response = null;
        if (!empty($reference)) {
            try {
                $response = $this->library_book_copies_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    /*
     * Book assign
     *
     * */
    public function book_copy_assign_to_user(ParameterBag $request)
    {
        $response = [];

        ## decide edit or add a books in library.
        $Entity__books_library_copy = null;
        if (!empty($request->get('____d__fe_rd__us__asig'))) {
            try {
                $Entity__books_library_copy = $this->library_assigned_repository->find($request->get('____d__fe_rd__us__asig'));
            } catch (\Exception $exception) {
            }
        }
        if (!$Entity__books_library_copy instanceof LibraryAssigned) {
            $Entity__books_library_copy = new LibraryAssigned();
        }

        ## get the user
        $new___ = new ParameterBag();
        $new___->set('id', $request->get('s__name'));
        $user__to = $this->user_service->pre__userCheck($new___);

        if (!$user__to instanceof User) {
            $response = $this->default_function->push_error($response, isset($user__to[0]) ? $user__to[0] : $user__to);
        }

        if (!empty($response)) {
            return $response;
        }


        ## convert date & time into the object
        $issue_datetime = null;
        $issue_end_datetime = null;

        try {
            $issue_datetime = new \DateTime($request->get('issue___date'));
            $issue_end_datetime = new \DateTime($request->get('issue__end_date'));
        } catch (\Exception $exception) {
        }

        ## set issue datetime to the now.
        if (empty($issue_datetime)) {
            $issue_datetime = new \DateTime('now');
        }

        ## set end issue datetime to the now
        if (empty($issue_end_datetime)) {
            $issue_end_datetime = new \DateTime('now');
        }


        ## get the library copies.
        $library_book_copy = $this->get_the_books__copies__in_library($request->get('____d__fe_rd__us__cop_ref'));
        if (!$library_book_copy instanceof LibraryBookCopies) {
            $response = $this->default_function->push_error($response, 'Invalidate Library book reference');
        }

        ## book is occupied by the user
        if ($library_book_copy->getIsOccpuied() == 1) {
            $response = $this->default_function->push_error($response, 'This book is already occupied by the other user');
        }

        if (!empty($response)) {
            return $response;
        }

        $Entity__books_library_copy->setNotes($request->get('notes__'));
        $Entity__books_library_copy->setBookAssignedBy($this->token_storage->getToken()->getUser());
        $Entity__books_library_copy->setBookAssignedTo($user__to);
        $Entity__books_library_copy->setIssueDate($issue_datetime);
        $Entity__books_library_copy->setIssusedEndDatetime($issue_end_datetime);
        $Entity__books_library_copy->setLibraryBookCopiesRef($library_book_copy);
        try {
            $this->entity_manager->persist($Entity__books_library_copy);
            $this->entity_manager->flush();
            $response = 'OK';


            ## mark this book copy is assigned to the user
            $library_book_copy->setIsOccpuied(true);
            $this->entity_manager->persist($library_book_copy);
            $this->entity_manager->flush();

        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;

    }

    ## return book by student to librarian
    public function return___book_by_student(ParameterBag $request)
    {
        $assigned__book = $this->get_the_assigned_books__copies__in_library($request->get('____book_asig'));
        if (!$assigned__book instanceof LibraryAssigned) {
            return $assigned__book;
        }

        ## convert date & time into the object
        $return__datetime = null;
        try {
            $return__datetime = new \DateTime($request->get('return___date'));
        } catch (\Exception $exception) {
        }

        ## set issue datetime to the now.
        if (empty($return__datetime)) {
            $return__datetime = new \DateTime('now');
        }


        ## get the library copy object
        $assigned__book->getLibraryBookCopiesRef()->setIsOccpuied(false);
        ## save the return datetime.
        $assigned__book->setReturnDate($return__datetime);
        $this->entity_manager->persist($assigned__book);
        $this->entity_manager->flush();

        return 'OK';
    }
    ## get the book assigend
    ## get the books copy from the library
    public function get_the_assigned_books__copies__in_library(int $reference)
    {
        $response = null;
        if (!empty($reference)) {
            try {
                $response = $this->library_assigned_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }


}
