<?php


namespace App\Service\Guardian\Import;


use App\Entity\User;
use App\Service\DefaultFunction;
use App\Service\Guardian\GuardianService;
use App\Service\Mics\Import\ImportBasicSettings;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

class ImportGuardianService extends ImportBasicSettings
{

    /**
     * @var GuardianService
     */
    private $guardianService;

    public function __construct(
        EntityManagerInterface $entityManager,
        GuardianService $guardianService
    ) {
        parent::__construct($entityManager);
        $this->guardianService = $guardianService;
    }

    public function pushCsvConvertedDataToDB()
    {

    }

    public function extractGuardianFromStudentCSVFile(Array $params, User $studentObject)
    {

        $returnArray = [];
        $guardianArray = new ParameterBag();
        $guardianArray2 = new ParameterBag();

        ## First name
        if (!empty($params['Guardian1_Fname'])) {
            $guardianArray->set('GfName', $params['Guardian1_Fname']);
        }

        if (!empty($params['Guardian2_Fname'])) {
            $guardianArray2->set('GfName', $params['Guardian2_Fname']);
        }

        ## Last name
        if (!empty($params['Guardian1_Lname'])) {
            $guardianArray->set('GlName', $params['Guardian1_Lname']);
        }

        if (!empty($params['Guardian2_Lname'])) {
            $guardianArray2->set('GlName', $params['Guardian2_Lname']);
        }

        ## Email
        if (!empty($params['Guardian1_Email'])) {
            $guardianArray->set('GEmail', $params['Guardian1_Email']);
        }
        if (!empty($params['Guardian2_Email'])) {
            $guardianArray2->set('GEmail', $params['Guardian2_Email']);
        }

        ## Password
        if (!empty($params['Guardian1_Email'])) {
            $guardianArray->set('secret', $params['Guardian1_Password']);
        }
        if (!empty($params['Guardian2_Email'])) {
            $guardianArray2->set('secret', $params['Guardian2_Password']);
        }

        ## Relationship.
        if (!empty($params['Guardian1_Relation'])) {
            $guardianArray->set('GR', $params['Guardian1_Relation']);
        } else {
            $guardianArray->set('GR', 'g');
        }
        if (!empty($params['Guardian2_Relation'])) {
            $guardianArray2->set('GR', $params['Guardian2_Relation']);
        } else {
            $guardianArray->set('GR', 'g');
        }

        ## active or not .
        if (!empty($params['Guardian1_Active']) && $params['Guardian1_Active'] == 1) {
            $guardianArray->set('GActive', true);
        } else {
            $guardianArray->set('GActive', false);
        }
        if (!empty($params['Guardian2_Active']) && $params['Guardian2_Active'] == 1) {
            $guardianArray2->set('GActive', true);
        } else {
            $guardianArray2->set('GActive', false);
        }

        ## Gender
        if (!empty($params['Guardian1_Gender']) && ($params['Guardian1_Gender'] == 1 || $params['Guardian1_Gender'] == 2 || $params['Guardian1_Gender'] == 3)) {
            $guardianArray->set('gender', $params['Guardian1_Gender']);
        } else {
            $guardianArray->set('gender', 1);
        }
        if (!empty($params['Guardian2_Gender']) && ($params['Guardian2_Gender'] == 1 || $params['Guardian2_Gender'] == 2 || $params['Guardian2_Gender'] == 3)) {
            $guardianArray2->set('gender', $params['Guardian1_Gender']);
        } else {
            $guardianArray2->set('gender', 1);
        }


        ## Guardian phone.
        if (!empty($params['Guardian1_Phone'])) {
            $guardianArray->set('GPhone', $params['Guardian1_Phone']);
        }
        if (!empty($params['Guardian2_Phone'])) {
            $guardianArray2->set('GPhone', $params['Guardian2_Phone']);
        }


        $guardianArray->set('studentObject', $studentObject);
        $guardianArray2->set('studentObject', $studentObject);

        ## save two guardians
        $response = $this->guardianService->registerGuardian($guardianArray);
        $response2 = $this->guardianService->registerGuardian($guardianArray2);

        array_push($returnArray, $response);
        array_push($returnArray, $response2);

        return $returnArray;
    }
}