<?php

namespace App\Repository;

use App\Entity\LibrarySections;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method LibrarySections|null find($id, $lockMode = null, $lockVersion = null)
 * @method LibrarySections|null findOneBy(array $criteria, array $orderBy = null)
 * @method LibrarySections[]    findAll()
 * @method LibrarySections[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class LibrarySectionsRepository extends ServiceEntityRepository
{

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, LibrarySections::class);
    }

    ## get all sections in the form of array.

    /**
     * @param int|null $reference
     * @return array
     */
    public function result_in_array(int $reference = null)
    {
        $queryBuilder = $this->createQueryBuilder('library_sections');

        ## get single one, if is not then get the all.
        if (!empty($reference)) {
            $queryBuilder->andwhere('library_sections.id = :reference')->setParameter('reference', $reference);
        }

        return $queryBuilder->getQuery()->getArrayResult();
    }


    ## get all section with their childerns.
    public function get_the_section_with_assosiated_childerns()
    {
        return $this->createQueryBuilder('library_sections')
            ->leftJoin('library_sections', 'library_s')
            ->getQuery()
            ->getSQL();
    }

}
