<?php

namespace App\Repository;

use App\Entity\Guardian;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method Guardian|null find($id, $lockMode = null, $lockVersion = null)
 * @method Guardian|null findOneBy(array $criteria, array $orderBy = null)
 * @method Guardian[]    findAll()
 * @method Guardian[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class GuardianRepository extends ServiceEntityRepository
{

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, Guardian::class);
    }

    ## find Not One By
    ## this method is used to find out there where "$value" of specific column is not equal to, of special user.
    public function findNotOneBy(string $key, $value, int $user_id)
    {
        return $this->createQueryBuilder('guardian')
            ->where(sprintf('guardian.%s= :value', $key))
            ->andWhere('guardian.id != :user_id')
            ->setParameter('value', $value)
            ->setParameter('user_id', $user_id)
            ->getQuery()
            ->getResult();

    }


    ## associated user with the email.
    public function getGuardianWhereGuardianNotByID($user_id, $email = null, $phone = null)
    {
        $queryBuilder = $this->createQueryBuilder('guardian');

        ## if email is given
        if (!empty($email)) {
            $queryBuilder->andWhere('guardian.guardian_email = :email')
                ->setParameter('email', $email);
        }

        ## if phone is given
        if (!empty($phone)) {
            $queryBuilder->andWhere('guardian.phone = :phone')
                ->setParameter('phone', $phone);
        }

        ## user id is given
        if (!empty($user_id)) {
            $queryBuilder->andWhere('guardian.id != :user_id')
                ->setParameter('user_id', $user_id);
        }

        return $queryBuilder->getQuery()->getResult();
    }
}
