<?php

namespace App\Form;

use App\Entity\CustomFields;
use App\Entity\UsersProfileCustomFields;
use App\Form\Model\AddingCustomFieldsToUserFormModel;
use App\Repository\CustomFieldSectionsRepository;
use App\Repository\CustomFieldsRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

class AddingCustomFieldsToUserFormType extends AbstractType {

	/**
	 * @var CustomFieldsRepository
	 */
	private $custom_fields_repository;
	/**
	 * @var CustomFieldSectionsRepository
	 */
	private $custom_field_sections_repository;

	public function __construct( CustomFieldsRepository $custom_fields_repository, CustomFieldSectionsRepository $custom_field_sections_repository ) {
		$this->custom_fields_repository         = $custom_fields_repository;
		$this->custom_field_sections_repository = $custom_field_sections_repository;
	}

	public function buildForm( FormBuilderInterface $builder, array $options ) {

		$builder## Input field label
		->add( 'label', TextType::class, [
			'label' => 'Field Label',
			'attr'  => [ 'placeholder' => 'What should be field Name?' ],
		] )## Input field type (e.x, text, textarea, dropdown and etc)
		->add( 'type', ChoiceType::class, [
			'choices' => [
				## Small or Medium text
				'Text'             => 'text',
				## Long text like description
				'Long Text'        => 'textarea',
				## Can multiple options (ex, I've multiple hobbies, so user can check cricket, reading and etc options)
				'Multiple Choices' => 'checkbox',
				## Can choose single option (ex, Gender is will be Male Or Female)
				'Single Choice'    => 'radio',
				## Dropdown
				## Telephone type
				'Telephone'        => 'tel',
				## Date input
				'Date'             => 'date',
				## time input <input type="time">
				'Time'             => 'time',
				## drop down field name.
				'Dropdown'         => 'dropdown',
				## file
				'Upload Documents' => 'file',
			],
			'label'   => 'Field Type',
			'attr'    => [
				'placeholder' => 'What should be the type of the Field?',
				'class'       => 'simpleSelect2 fieldType',
			],
		] )## if we choose dropdown or radio field type
		/*->add( 'options', CollectionType::class, [
			'label'         => false,
			'entry_type'    => TextType::class,
			'entry_options' => [],
			'allow_add'     => true,
			'prototype'     => true,

		] )*/ ## Place holder of input field.
		->add( 'placeholder', TextType::class, [
			'label' => 'Field Place holder',
			'attr'  => [ 'placeholder' => 'Hint for the Field answers?' ],
		] )##  GIve field is required or not
		->add( 'help_message', TextType::class, [
			'label' => 'Help message',
			'attr'  => [ 'placeholder' => 'To help user for fill the field' ],
		] )
			/*## Is this field only for the administrators
		->add( 'admin', CheckboxType::class, [
			'label'    => 'Admin',
			'required' => false,
		] )## Is this field only for the teachers?
		->add( 'teacher', CheckboxType::class, [
			'label'    => 'Teacher',
			'required' => false,
		] )## Is this field only for the students?
		->add( 'student', CheckboxType::class, [
			'label'    => 'Student',
			'required' => false,
		] )*/ /*->add( 'is_lock', CheckboxType::class, [
			'label'    => 'User can update this field?',
			'required' => false,
		] )*/

			/*->add( 'custom_field_sections_id', ChoiceType::class, [
				'choices'            => $this->custom_field_sections_repository->findAll(),
				'choice_label'       => function ( $category, $key ) {
					dump( $category );
					//return $category;
				},
				'choice_value'       => function ( $category ) {
							if ( $category == '==No Section==' ) {
									$value = '';
								} else {
									$value = $category;
								}

								return $value;
				},
				'group_by'           => function () {
					return '';
				},
				'attr'               => [
					'class' => 'kt_select2_11',
				],
				'allow_extra_fields' => true,
			] )*/

			## Submit Button.
			/*->add( 'createField', SubmitType::class, [
			'label' => 'Create Field',
			'attr'  => [
				'class' => 'btn-primary',
			],
		] )*/
		;

		/*$builder->get( 'section' )->resetViewTransformers();
		$builder->addEventListener( FormEvents::PRE_SUBMIT, function ( FormEvent $event ) {
			return $event->getData();
		} );*/
	}

	public function configureOptions( OptionsResolver $resolver ) {
		$resolver->setDefaults( [
			'data_class' => AddingCustomFieldsToUserFormModel::class,
			'method'     => 'post',
		] );
	}
}
