<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity(repositoryClass="App\Repository\TransactionsRepository")
 */
class Transactions {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 *
	 *
	 * @ORM\Column(type="datetime")
	 */
	private $trans_datetime;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $trans_notes;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="transactions_by")
	 */
	private $trans_by;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $trans_reference;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="transaction_paid_to")
	 */
	private $trans_paid_to;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\Invoices", inversedBy="transactions")
	 */
	private $invoice_reference;

	/**
	 * @ORM\Column(type="integer")
	 */
	private $amount;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_expense_or_income;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\AccountHeads", inversedBy="transactions")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $income_head;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\PaymentMethods", inversedBy="transactions")
	 */
	private $payment_method_reference;

	/**
	 * @ORM\Column(type="string", length=60, nullable=true)
	 */
	private $unregister_paid_to_user;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\Accounts", inversedBy="transactions")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $accounts_reference;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $trans_description;

	/**
	 * @ORM\Column(type="boolean")
	 */
	private $is_instant_payment;

	public function getId(): ?int {
		return $this->id;
	}

	public function getTransDatetime(): ?\DateTimeInterface {
		return $this->trans_datetime;
	}

	public function setTransDatetime( \DateTimeInterface $trans_datetime ): self {
		$this->trans_datetime = $trans_datetime;

		return $this;
	}

	public function getTransNotes(): ?string {
		return $this->trans_notes;
	}

	public function setTransNotes( ?string $trans_notes ): self {
		$this->trans_notes = $trans_notes;

		return $this;
	}

	public function getTransBy(): ?User {
		return $this->trans_by;
	}

	public function setTransBy( ?User $trans_by ): self {
		$this->trans_by = $trans_by;

		return $this;
	}

	public function getTransReference(): ?string {
		return $this->trans_reference;
	}

	public function setTransReference( string $trans_reference ): self {
		$this->trans_reference = $trans_reference;

		return $this;
	}

	public function getTransPaidTo(): ?User {
		return $this->trans_paid_to;
	}

	public function setTransPaidTo( ?User $trans_paid_to ): self {
		$this->trans_paid_to = $trans_paid_to;

		return $this;
	}

	public function getInvoiceReference(): ?Invoices {
		return $this->invoice_reference;
	}

	public function setInvoiceReference( ?Invoices $invoice_reference ): self {
		$this->invoice_reference = $invoice_reference;

		return $this;
	}

	public function getAmount(): ?int {
		return $this->amount;
	}

	public function setAmount( int $amount ): self {
		$this->amount = $amount;

		return $this;
	}

	public function getIsExpenseOrIncome(): ?bool {
		return $this->is_expense_or_income;
	}

	public function setIsExpenseOrIncome( bool $is_expense_or_income ): self {
		$this->is_expense_or_income = $is_expense_or_income;

		return $this;
	}

	public function getIncomeHead(): ?AccountHeads {
		return $this->income_head;
	}

	public function setIncomeHead( ?AccountHeads $income_head ): self {
		$this->income_head = $income_head;

		return $this;
	}

	public function getPaymentMethodReference(): ?PaymentMethods {
		return $this->payment_method_reference;
	}

	public function setPaymentMethodReference( ?PaymentMethods $payment_method_reference ): self {
		$this->payment_method_reference = $payment_method_reference;

		return $this;
	}

	public function getUnregisterPaidToUser(): ?string {
		return $this->unregister_paid_to_user;
	}

	public function setUnregisterPaidToUser( ?string $unregister_paid_to_user ): self {
		$this->unregister_paid_to_user = $unregister_paid_to_user;

		return $this;
	}

	public function getAccountsReference(): ?Accounts {
		return $this->accounts_reference;
	}

	public function setAccountsReference( ?Accounts $accounts_reference ): self {
		$this->accounts_reference = $accounts_reference;

		return $this;
	}

	public function getTransDescription(): ?string {
		return $this->trans_description;
	}

	public function setTransDescription( ?string $trans_description ): self {
		$this->trans_description = $trans_description;

		return $this;
	}

	public function getIsInstantPayment(): ?bool {
		return $this->is_instant_payment;
	}

	public function setIsInstantPayment( bool $is_instant_payment ): self {
		$this->is_instant_payment = $is_instant_payment;

		return $this;
	}
}
