<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\SubjectsRepository")
 */
class Subjects
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=150)
     */
    private $subject_name;

    /**
     * @ORM\Column(type="string", length=45, nullable=true)
     */
    private $short_name;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $credits;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $fee;

    /**
     * @ORM\Column(type="smallint")
     */
    private $hidden = false;

    /*
     * @ORM\OneToOne(targetEntity="App\Entity\ClassSubjectTemplate", mappedBy="subject__", cascade={"persist",
     *                                                               "remove"})
     */
    /*private $class_subject_template;*/

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSubjectTemplate", mappedBy="subject__", orphanRemoval=true)
     */
    private $classSubjectTemplates;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $marks;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $pass_marks;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClassesStudent", mappedBy="subject")
     */
    private $examsClassesStudents;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSubject", mappedBy="subject")
     */
    private $classSubjects;



    public function __construct()
    {
        $this->classSubjectTemplates = new ArrayCollection();
        $this->examsClassesStudents = new ArrayCollection();
        $this->classSubjects = new ArrayCollection();
        //$this->classSubjects         = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSubjectName(): ?string
    {
        return $this->subject_name;
    }

    public function setSubjectName(string $subject_name): self
    {
        $this->subject_name = $subject_name;

        return $this;
    }

    public function getShortName(): ?string
    {
        return $this->short_name;
    }

    public function setShortName(?string $short_name): self
    {
        $this->short_name = $short_name;

        return $this;
    }

    public function getCredits(): ?int
    {
        return $this->credits;
    }

    public function setCredits(?int $credits): self
    {
        $this->credits = $credits;

        return $this;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function setFee(?float $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    public function getHidden(): ?int
    {
        return $this->hidden;
    }

    public function setHidden(int $hidden): self
    {
        $this->hidden = $hidden;

        return $this;
    }

    /**
     * @return Collection|ClassSubjectTemplate[]
     */
    public function getClassSubjectTemplates(): Collection
    {
        return $this->classSubjectTemplates;
    }

    public function addClassSubjectTemplate(ClassSubjectTemplate $classSubjectTemplate): self
    {
        if (!$this->classSubjectTemplates->contains($classSubjectTemplate)) {
            $this->classSubjectTemplates[] = $classSubjectTemplate;
            $classSubjectTemplate->setSubject($this);
        }

        return $this;
    }

    public function removeClassSubjectTemplate(ClassSubjectTemplate $classSubjectTemplate): self
    {
        if ($this->classSubjectTemplates->contains($classSubjectTemplate)) {
            $this->classSubjectTemplates->removeElement($classSubjectTemplate);
            // set the owning side to null (unless already changed)
            if ($classSubjectTemplate->getSubject() === $this) {
                $classSubjectTemplate->setSubject(null);
            }
        }

        return $this;
    }

    public function getMarks(): ?float
    {
        return $this->marks;
    }

    public function setMarks(?float $marks): self
    {
        $this->marks = $marks;

        return $this;
    }

    public function getPassMarks(): ?float
    {
        return $this->pass_marks;
    }

    public function setPassMarks(?float $pass_marks): self
    {
        $this->pass_marks = $pass_marks;

        return $this;
    }

    /**
     * @return Collection|ExamsClassesStudent[]
     */
    public function getExamsClassesStudents(): Collection
    {
        return $this->examsClassesStudents;
    }

    public function addExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if (!$this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents[] = $examsClassesStudent;
            $examsClassesStudent->setSubject($this);
        }

        return $this;
    }

    public function removeExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if ($this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents->removeElement($examsClassesStudent);
            // set the owning side to null (unless already changed)
            if ($examsClassesStudent->getSubject() === $this) {
                $examsClassesStudent->setSubject(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    /**
     * @return Collection|ClassSubject[]
     */
    public function getClassSubjects(): Collection
    {
        return $this->classSubjects;
    }

    public function addClassSubject(ClassSubject $classSubject): self
    {
        if (!$this->classSubjects->contains($classSubject)) {
            $this->classSubjects[] = $classSubject;
            $classSubject->setSubject($this);
        }

        return $this;
    }

    public function removeClassSubject(ClassSubject $classSubject): self
    {
        if ($this->classSubjects->contains($classSubject)) {
            $this->classSubjects->removeElement($classSubject);
            // set the owning side to null (unless already changed)
            if ($classSubject->getSubject() === $this) {
                $classSubject->setSubject(null);
            }
        }

        return $this;
    }

    /*
     * @deprecated 25-07-2019
     * @return Collection|ClassSubject[]
     */
    /*public function getClassSubjects(): Collection {
        return $this->classSubjects;
    }

    public function addClassSubject( ClassSubject $classSubject ): self {
        if ( ! $this->classSubjects->contains( $classSubject ) ) {
            $this->classSubjects[] = $classSubject;
            $classSubject->addSubject( $this );
        }

        return $this;
    }

    public function removeClassSubject( ClassSubject $classSubject ): self {
        if ( $this->classSubjects->contains( $classSubject ) ) {
            $this->classSubjects->removeElement( $classSubject );
            $classSubject->removeSubject( $this );
        }

        return $this;
    }*/
}
