<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Entity(repositoryClass="App\Repository\StudentGradesRepository")
 */
class StudentGrades
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=5)
     * @Assert\NotBlank(message="Grade name should not be null")
     * @Assert\Length(min=1, max=5, minMessage="Grade must be at least {{ limit }} characters long", maxMessage =
     *                       "Grade cannot be longer than {{ limit }} characters")
     */
    private $student_grade_name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Assert\Length(max=255,  maxMessage =
     *                       "Grade Description be longer than {{ limit }} characters")
     */
    private $student_grade_desc;

    /**
     * @ORM\Column(type="smallint")
     * @Assert\NotBlank
     * @Assert\Length(min=1, max=6, minMessage="Marks must be at least {{ limit }} characters long", maxMessage =
     *                       "Marks cannot be longer than {{ limit }} characters")
     */
    private $student_grade_equal_or_greater_than_marks;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\GradeCategories", inversedBy="studentGrades")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotBlank(message="Grade category reference should not be null")
     * @Assert\Valid
     */
    private $student_grade_category;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStudentGradeName(): ?string
    {
        return $this->student_grade_name;
    }

    public function setStudentGradeName(string $student_grade_name): self
    {
        $this->student_grade_name = $student_grade_name;

        return $this;
    }

    public function getStudentGradeDesc(): ?string
    {
        return $this->student_grade_desc;
    }

    public function setStudentGradeDesc(?string $student_grade_desc): self
    {
        $this->student_grade_desc = $student_grade_desc;

        return $this;
    }

    public function getStudentGradeEqualOrGreaterThanMarks(): ?int
    {
        return $this->student_grade_equal_or_greater_than_marks;
    }

    public function setStudentGradeEqualOrGreaterThanMarks(int $student_grade_equal_or_greater_than_marks): self
    {
        $this->student_grade_equal_or_greater_than_marks = $student_grade_equal_or_greater_than_marks;

        return $this;
    }

    public function getStudentGradeCategory(): ?GradeCategories
    {
        return $this->student_grade_category;
    }

    public function setStudentGradeCategory(?GradeCategories $student_grade_category): self
    {
        $this->student_grade_category = $student_grade_category;

        return $this;
    }
}
