<?php

namespace App\DataFixtures;

use App\Entity\User;
use App\Repository\UserRepository;
use App\Service\UserRegistration;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class UserFixtures extends Fixture {

	private $faker;
	/**
	 * @var UserPasswordEncoderInterface
	 */
	private $password_encoder;
	/**
	 * @var UserRegistration
	 */
	private $user_repository;
	/**
	 * @var UserRegistration
	 */
	private $user_registration;


	const UserFixtureReference = 'user_fixture_reference__';

	public function __construct( UserPasswordEncoderInterface $password_encoder, UserRegistration $user_registration ) {
		$this->password_encoder  = $password_encoder;
		$this->user_registration = $user_registration;
	}

	public function load( ObjectManager $manager ) {
		$this->faker = Factory::create();
		for ( $x = 0; $x < 10; $x++ ) {
			$User = new \App\Entity\User();
			$User->setFName( $this->faker->firstName );
			$User->setLName( $this->faker->lastName );
			$User->setIsActive( true );
			$User->setRoles( [ 'ROLE_ADMIN' ] );
			$User->setCategory( 's' );
			$User->setGender( 1 );
			$User->setEmail( 'email@email.com' );
			$User->setAdmissionNumber( $x );
			$User->setPassword( $this->password_encoder->encodePassword( $User, 'testing' ) );
			$this->addReference( self::UserFixtureReference . $x, $User );
			$manager->persist( $User );
		}

		$manager->flush();
	}
}
