<?php

namespace App\DataFixtures;

use App\Entity\ClassTemplate;
use App\Entity\Session;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;

class SessionFixtures extends Fixture {

	private $faker;
	const SessionFixturesReference = 'session_fixtures_____Reference';

	public function load( ObjectManager $manager ) {
		$this->faker = Factory::create();

		for ( $x = 0; $x < 10; $x ++ ) {

			$Entity = new Session();
			$Entity->setName( $this->faker->name );
			$Entity->setDescription( $this->faker->sentence );
			$Entity->setActive( 1 );
			$Entity->setEndDate( new \DateTime() );
			$Entity->setStartDate( new \DateTime() );
			$Entity->setShortName( $this->faker->name );
			$this->addReference( self::SessionFixturesReference . $x, $Entity );
			$manager->persist( $Entity );
		}

		$manager->flush();
	}

}
