<?php

namespace App\DataFixtures;

use App\Entity\EmailTemplates;
use App\Service\Constants;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;
use Gedmo\Translatable\Translatable;

class EmailTemplateFixtures extends Fixture {

	private $faker;
	public const EMAIL_TEMPLATE_REFERENCE = 'emailTemplateReference';

	public function load( ObjectManager $manager ) {

		$this->faker = Factory::create();

		for ( $x = 0; $x < 10; $x ++ ) {

			$emailTemplate = new EmailTemplates();
			// email template name.
			$emailTemplate->setName( $this->faker->sentence( 6, true ) );
			$emailTemplate->setSubject( $this->faker->text( 10 ) );
			$emailTemplate->setContent( $this->faker->realText() );
			$emailTemplate->setCreatedAt( $this->faker->dateTime( 'now' ) );
			$emailTemplate->setUpdatedAt( $this->faker->dateTime( 'now' ) );
			$temp_array = [
				's_name',
				't_name',
				'a_name',
				'g_name',
				's_admission_number',
			];
			$emailTemplate->setVariables( $temp_array );
			$emailTemplate->setEmailTemplateEvents( $this->getReference( EmailTemplateEvents::EmailTemplateEventReference . '_' . $x ) );
			$temp_array = [
				's',
				'a',
				't',
			];
			$emailTemplate->setAssignedTo( $temp_array[ rand( 0, 2 ) ] );
			$emailTemplate->setIsActive( $this->faker->boolean( 50 ) );
			$this->addReference( self::EMAIL_TEMPLATE_REFERENCE . '_' . $x, $emailTemplate );


			## save multilang email templates. /** @var Translatable */


			/** @var Translatable */
			$repository__d = $manager->getRepository( 'Gedmo\\Translatable\\Entity\\Translation' );

			foreach ( Constants::SupportedLanguages as $key => $value ) {
				$repository__d->translate( $emailTemplate, 'subject', $key, 'Translate in ' . $value );
				$repository__d->translate( $emailTemplate, 'content', $key, 'Translate in ' . $value );
			}

			$manager->persist( $emailTemplate );

		}


		$manager->flush();
	}
}
