<?php


namespace App\Service\accounts;


use App\Entity\AccountHeads;
use App\Entity\Accounts;
use App\Entity\Invoices;
use App\Entity\PaymentMethods;
use App\Entity\Transactions;
use App\Entity\User;
use App\Repository\InvoiceItemsRepository;
use App\Repository\InvoicesRepository;
use App\Repository\TransactionsRepository;
use App\Repository\UserRepository;
use App\Service\DefaultFunction;
use App\Service\FileManagment;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\FileBag;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\PropertyAccess\PropertyAccessor;

class TransactionService
{

    const chat__attachment_file = 'transactions' . DIRECTORY_SEPARATOR;

    /**
     * @var DefaultFunction
     */

    private $default_function;
    /**
     * @var TransactionsRepository
     */
    private $transactions_repository;
    /**
     * @var \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface
     */
    private $token_storage;
    /**
     * @var UserRepository
     */
    private $user_repository;
    /**
     * @var InvoicesRepository
     */
    private $invoices_repository;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var FileManagment
     */
    private $file_managment;
    /**
     * @var AccountsService
     */
    private $accounts_service;
    /**
     * @var InvoiceItemsRepository
     */
    private $invoice_items_repository;
    /**
     * @var InvoiceService
     */
    private $invoice_service;

    public function __construct(InvoiceService $invoice_service, DefaultFunction $default_function, InvoiceItemsRepository $invoice_items_repository, AccountsService $accounts_service, FileManagment $file_managment, TransactionsRepository $transactions_repository, \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface $token_storage, UserRepository $user_repository, InvoicesRepository $invoices_repository, EntityManagerInterface $entity_manager)
    {
        $this->default_function = $default_function;
        $this->transactions_repository = $transactions_repository;
        $this->token_storage = $token_storage;
        $this->user_repository = $user_repository;
        $this->invoices_repository = $invoices_repository;
        $this->entity_manager = $entity_manager;
        $this->file_managment = $file_managment;
        $this->accounts_service = $accounts_service;
        $this->invoice_items_repository = $invoice_items_repository;
        $this->invoice_service = $invoice_service;
    }


    /*
     * == Transaction
     * */

    ## validate transaction before save
    public function validate__transactions(ParameterBag $request)
    {
        $response = [];

        ## trans is income or expense should not be null.
        if (empty($request->get('trans___is_inc_exp'))) {
            $response = $this->default_function->push_error($response, 'Please describe this transactions is expense or income');
        }

        ## transaction amount
        if (empty($request->get('trans__am'))) {
            $response = $this->default_function->push_error($response, 'Please type transaction amount');
        }

        ## for which user this transaction is done.
        ## before that check, user is system user or walk in user.
        if ($request->get('get__us__fr_in') <> 1) {
            if (empty($request->get('u____s'))) {
                $response = $this->default_function->push_error($response, 'Please select user is system user or un-register user');
            } else {

                if ($request->get('u____s') == 'w__') {
                    ## if user is walk in then validate that, walk-in user name is given or not.
                    if (empty($request->get('w__u_n'))) {
                        $response = $this->default_function->push_error($response, 'Please enter walk in user name.');
                    }
                } else {
                    ## user is system register user.
                    if (empty($request->get('s__u_n'))) {
                        ## if system user is null or empty then return back to fill out the required fields.
                        $response = $this->default_function->push_error($response, 'Please enter system register username');
                    }
                }
            }
        }

        ## check the invoice reference
        ## when transaction is income then we've to save the invoice reference because every income has invoice.
        //		if ( empty( $request->get( 'trans__inv_ref' ) ) && $request->get( 'trans___is_inc_exp' ) == 2 ) {
        //			## transaction no is autoGenerated.
        //			$request->set( 'trans__inv_ref', uniqid( 'transRef_' ) );
        //			$response = $this->default_function->push_error( $response, 'Please type Invoice reference - Income must contain invoice reference.' );
        //		}

        ## check account reference
        if (empty($request->get('trans__ac_ref'))) {
            $response = $this->default_function->push_error($response, 'Account reference is null');
        }

        ## check account head reference
        if (empty($request->get('trans_ac_hed_ref'))) {
            $response = $this->default_function->push_error($response, 'Account head reference is null');
        }

        return $response;

    }

    ## auto generate transaction.
    ## if user enter some transaction  number, system will keep it and check is this in database.
    ## if is in database, then we will keep of autoGenerated number otherwise we will keep user generated number.
    public function autoGeneratedTransaction($transRef)
    {
        if (!empty($transRef)) {
            $transNo = $transRef;

            ## check existence in database.
            $Transaction = $this->get_the__transaction($transRef, 'trans_reference');
            if ($Transaction instanceof Transactions) {
                $transNo = uniqid('trans_');
            }
        } else {
            $transNo = uniqid('trans_');
        }

        return $transNo;
    }

    ## add edit transactions.
    public function _add_edit_transactions(ParameterBag $request, FileBag $file_bag)
    {
        $response = [];

        if (!empty($validation_response = $this->validate__transactions($request))) {
            return $validation_response;
        }

        $Entity = null;
        if (empty($request->get('trans___iIFISDD'))) {
            ## add new record.
            $Entity = new Transactions();
        } else {
            ## edit existing record.
            try {
                $Entity = $this->transactions_repository->find($request->get('trans___iIFISDD'));
            } catch (\Exception $exception) {
            }
        }

        ## if transaction is still failed to get the trans entity the make again
        if (!$Entity instanceof Transactions) {
            $Entity = new Transactions();
        }

        ## if trans by is not empty.
        if ($this->token_storage->getToken()->getUser() instanceof User) {
            $Entity->setTransBy($this->token_storage->getToken()->getUser());
        }

        $inv__ref = null;

        if (!empty($request->get('trans__inv_ref'))) {
            if ($request->get('trans___is_inc_exp') == 2) {
                ## when adding invoice as income or transaction.
                ## if invoice is not found & and transaction is income then thrown an error -  that invoice is not found
                $inv__ref = $this->invoice_service->get__the__invoice($request->get('trans__inv_ref'));
            }

            ## if invoice is nto found then try to find out with the invoice reference
            if (!$inv__ref instanceof Invoices) {
                $inv__ref = $this->invoice_service->get__the__invoice(null, 'inv_reference', $request->get('trans__inv_ref'));
            }
        }

        ## if invoice found then add the invoice reference.
        if ($inv__ref instanceof Invoices) {
            ## if invoice is found then store it reference
            $Entity->setInvoiceReference($inv__ref);
            ## validate - this invoice is paid or not paid - or how much he has paid.
            $trans__possibility_reposne = $this->trans__is_possible_or_not($inv__ref->getId());
            if (!empty($trans__possibility_reposne)) {
                $response = $this->default_function->push_error($response, $trans__possibility_reposne);
            }

        }

        /**
         * @Depreactead 2 Dec 2019
         * */
//        if (!empty($request->get('trans__inv_ref'))) {
//
//            ## find invoice from database
//            $inv__ref = $this->invoice_service->get__the__invoice(null, 'inv_reference', $request->get('trans__inv_ref'));
//            if ($inv__ref instanceof Invoices) {
//                ## if invoice is found then store it reference
//                $Entity->setInvoiceReference($inv__ref);
//
//                ## validate - this invoice is paid or not paid - or how much he has paid.
//                $trans__possibility_reposne = $this->trans__is_possible_or_not($inv__ref->getId());
//                if (!empty($trans__possibility_reposne)) {
//                    $response = $this->default_function->push_error($response, $trans__possibility_reposne);
//                }
//
//            } elseif ($request->get('trans___is_inc_exp') == 2) {
//
//                $response = $this->default_function->push_error($response, 'Invoice is not exits in the system');
//
//            }
//        }

        ## return error if exits.
        if (!empty($response)) {
            return $response;
        }


        ## invoice are directly related to the invoice if paid to user is not mentioned then we can get the user from the invoice - only in case of income.
        ##  moreover - when we are paying some invoice we will get user from the invoice
        if ($request->get('get__us__fr_in') == 1) {
            ## get paid to user from the invoice reference.
            ## if we found the valid invoice.
            if ($inv__ref instanceof Invoices) {
                if ($inv__ref->getInvGeneratedFor() instanceof User) {
                    ## save paid to register user
                    $Entity->setTransPaidTo($inv__ref->getInvGeneratedFor());
                    $Entity->setUnregisterPaidToUser(null);
                } else {
                    ## save paid to by un-register user.
                    $Entity->setUnregisterPaidToUser($inv__ref->getInvoiceGeneratedForUnregisterUsername());
                    $Entity->setTransPaidTo(null);
                }
            }

        } else {
            ## save paid to
            ## if user is system user.
            if ($request->get('u____s') == 'w__' && !empty($request->get('w__u_n'))) {
                ## save paid to by un-register user.
                $Entity->setUnregisterPaidToUser($request->get('w__u_n'));
                $Entity->setTransPaidTo(null);
            } else {
                $paid_to_user = null;
                ## get the user object.
                try {
                    $paid_to_user = $this->user_repository->find($request->get('s__u_n'));
                } catch (\Exception $exception) {
                    $response = $this->default_function->push_error($response, $exception->getMessage());
                }
                ## if user is found in the database.
                if ($paid_to_user instanceof User) {
                    ## save paid to register user
                    $Entity->setTransPaidTo($paid_to_user);
                    $Entity->setUnregisterPaidToUser(null);
                } else {
                    $response = $this->default_function->push_error($response, 'Invalid user reference');
                }
            }
        }

        ## save transaction reference.
        $Entity->setTransReference($this->autoGeneratedTransaction($request->get('tran___ref')));
        ## save transaction notes.
        $Entity->setTransNotes($request->get('tran___n_t'));
        ## save transaction amount
        $Entity->setAmount($request->get('trans__am'));
        ## save transaction is expense or income
        $Entity->setIsExpenseOrIncome($this->default_function->parse__boolean($request->get('trans___is_inc_exp')));

        ## save payment method
        if (!empty($request->get('trans__payM__ref'))) {
            $payment_method_response = $this->accounts_service->get__the_payment_method($request->get('trans__payM__ref'));
            if ($payment_method_response instanceof PaymentMethods) {
                $Entity->setPaymentMethodReference($payment_method_response);
            }
        }

        ## save the account
        $account_response = $this->accounts_service->get__the_account_($request->get('trans__ac_ref'));
        if ($account_response instanceof Accounts) {
            $Entity->setAccountsReference($account_response);
        } else {
            $response = $this->default_function->push_error($response, (string)$account_response);
        }

        ## save the account head.
        $account_head_response = $this->accounts_service->get__the_account_head_($request->get('trans_ac_hed_ref'));
        if ($account_head_response instanceof AccountHeads) {
            $Entity->setIncomeHead($account_head_response);
        } else {
            $response = $this->default_function->push_error($response, (string)$account_head_response);
        }

        ## save the transaction date
        $Entity->setTransDatetime($this->default_function->convert_datetimeStringIntoObject($request->get('tran___dt')));

        ## save transaction description
        $Entity->setTransDescription($request->get('tran___des'));

        ## save this is the instant of or not instant payment
        $Entity->setIsInstantPayment($this->default_function->parse__boolean($request->get('trans___instan_pay')));


        ## return error if exits.
        if (!empty($response)) {
            return $response;
        }

        try {
            $this->entity_manager->persist($Entity);
            $this->entity_manager->flush();
            $response = 'OK';

            ## upload file with the transaction if exits.
            $this->upload__trans_doc($file_bag, $Entity->getId());
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }


        return $response;
    }

    ##  transaction is possible or not.
    public function trans__is_possible_or_not(int $invID)
    {
        $response = null;
        $__transaction_amount_regarding_invoice = $this->transactions_repository->count__transaction_amount_regariding__invoice($invID);
        $__invoice__total_amount = $this->invoice_items_repository->get_the_to_total_amount_regarding_invoice($invID);

        ## if transaction amount is greater or equal to the amount the transaction is not possbile.
        if ($__transaction_amount_regarding_invoice >= $__invoice__total_amount) {
            $response = 'Transaction is not possible, because this invoice is already paid';
        }

        return $response;

    }

    ## upload document with transaction.
    public function upload__trans_doc(FileBag $file_bag, $transactionId)
    {
        $args = [
            'fileArray' => $file_bag->get('trans__fi'),
            'public' => true,
            'path' => self::chat__attachment_file . $transactionId . DIRECTORY_SEPARATOR,
        ];

        $response = $this->file_managment->uploadFile($args);

        ## if file upload successfully
        if (is_array($response) && !empty($response['response'])) {
            $response = $response['response'];
        }

        return $response;

    }

    ## get the transaction.
    public function get_the__transaction($refer, $key = null)
    {
        $response = null;
        if (!empty($refer)) {
            try {
                if (empty($key)) {
                    // if column is not defined then search by id column
                    $response = $this->transactions_repository->find($refer);
                } else {
                    // find by other Column.
                    $response = $this->transactions_repository->findOneBy([$key => $refer]);
                }
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    ## get the income
    public function get_the_income(ParameterBag $parameterBag)
    {
        $bag = new ParameterBag();
        $bag->set('transactionDateRange', $parameterBag->get('dateRange'));
        $bag->set('is_expense_or_income', 2);

        return $this->transactions_repository->advanceSearch($bag);
    }

    ## get the expense
    public function get_the_expense(ParameterBag $parameterBag)
    {
        $bag = new ParameterBag();
        $bag->set('transactionDateRange', $parameterBag->get('dateRange'));
        $bag->set('is_expense_or_income', 1);
        return $this->transactions_repository->advanceSearch($bag);
    }
}