<?php


namespace App\Service\accounts;


use App\Entity\AccountHeads;
use App\Entity\PaymentMethods;
use App\Repository\AccountHeadsRepository;
use App\Repository\AccountsRepository;
use App\Repository\PaymentMethodsRepository;
use App\Service\DefaultFunction;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\ParameterBag;
use Twig\Environment;

class AccountsService {


	/**
	 * @var DefaultFunction
	 */
	private $default_function;
	/**
	 * @var AccountsRepository
	 */
	private $accounts_repository;
	/**
	 * @var EntityManagerInterface
	 */
	private $entity_manager;
	/**
	 * @var PaymentMethodsRepository
	 */
	private $payment_methods_repository;
	/**
	 * @var AccountHeadsRepository
	 */
	private $account_heads_repository;
	/**
	 * @var Environment
	 */
	private $environment;

	public function __construct(  DefaultFunction $default_function, AccountsRepository $accounts_repository, EntityManagerInterface $entity_manager, PaymentMethodsRepository $payment_methods_repository, AccountHeadsRepository $account_heads_repository, Environment $environment ) {
		$this->default_function           = $default_function;
		$this->accounts_repository        = $accounts_repository;
		$this->entity_manager             = $entity_manager;
		$this->payment_methods_repository = $payment_methods_repository;
		$this->account_heads_repository   = $account_heads_repository;
		$this->environment                = $environment;
	}


	/*
	 * Accounts
	 * */

	## validate the accounts before save data in it.
	public function validate__accounts( ParameterBag $request ) {
		$response = [];

		## if account name is empty
		if ( empty( $request->get( 'acc_n' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please type account name' );
		}

		## if account type is empty
		if ( empty( $request->get( 'acc_ty' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Account type should not be null' );
		}

		## if account is online
		if ( empty( $request->get( 'acc_IO' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Account is online or offline' );
		}

		## if account is default
		if ( empty( $request->get( 'acc_ID' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Account must be selected as default or not to be default' );
		}


		## user adding a new record.
		if ( empty( $request->get( 'acc__rf' ) ) ) {
			## if account name already exits.
			$account__repo_resp = $this->accounts_repository->findOneBy( [ 'acc_name' => $request->get( 'acc_n' ) ] );
			if ( $account__repo_resp instanceof \App\Entity\Accounts ) {
				$response = $this->default_function->push_error( $response, 'Account name with ' . $request->get( 'acc_n' ) . ' name is already exits' );
			}


			## make sure other account doesn't have default value.
			if ( $request->get( 'acc_ID' ) == '2' ) {
				$account__repo_resp = $this->accounts_repository->findOneBy( [ 'acc_is_default' => true ] );
				if ( $account__repo_resp instanceof \App\Entity\Accounts ) {
					$response = $this->default_function->push_error( $response, 'Unable to make it default because - account ' . $account__repo_resp->getAccName() . ' is already selected as a default' );
				}
			}
		}

		return $response;

	}

	## add or update the account
	public function _add_update_accounts( ParameterBag $request ) {
		$response = [];

		## if validation rule is voilates
		if ( ! empty( $validation_resposne = $this->validate__accounts( $request ) ) ) {
			return $validation_resposne;
		}

		$account = null;

		if ( empty( $request->get( 'acc__rf' ) ) ) {
			## add new account
			$account = new \App\Entity\Accounts();
		} else {
			## update an account
			try {
				$account = $this->accounts_repository->find( $request->get( 'acc__rf' ) );
			} catch ( \Exception $exception ) {
			}
		}

		## if still account entity not found then create
		if ( ! $account instanceof \App\Entity\Accounts ) {
			$account = new \App\Entity\Accounts();
		}


		$account->setAccDescrption( $request->get( 'acc_de' ) );
		$account->setAccIsDefault( $this->default_function->parse__boolean( $request->get( 'acc_ID' ) ) );
		$account->setAccType( $request->get( 'acc_ty' ) );
		$account->setAccIsOnline( $this->default_function->parse__boolean( $request->get( 'acc_IO' ) ) );
		$account->setAccName( $request->get( 'acc_n' ) );


		try {
			$this->entity_manager->persist( $account );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $account->getId() . '_af_d_f_____' . $this->environment->render( 'accounts/accounts_list_view.html.twig', [ 'account__list' => [ $account ] ] );

		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );
		}

		return $response;

	}

	## get the the account
	public function get__the_account_( $reference ) {
		$response = null;
		if ( ! empty( $reference ) ) {
			try {
				$response = $this->accounts_repository->find( $reference );
			} catch ( \Exception $exception ) {
				$response = $exception->getMessage();
			}
		}

		return $response;
	}

	/*
	 * Account heads.
	 * */

	## validate the accounts heads before save data in it.
	public function validate__accounts__head( ParameterBag $request ) {
		$response = [];

		## if account head name is empty
		if ( empty( $request->get( 'ah__ne' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please type account head name' );
		} else if ( empty( $request->get( 'ah__rf' ) ) ) {
			## if account head is already exits.
			$account_head__repo_resp = $this->account_heads_repository->findOneBy( [ 'ah_name' => $request->get( 'ah__ne' ) ] );
			if ( $account_head__repo_resp instanceof AccountHeads ) {
				$response = $this->default_function->push_error( $response, 'Account head  with ' . $request->get( 'ah__ne' ) . ' name is already exits' );
			}
		}

		## if account type is empty
		if ( empty( $request->get( 'ah__ty' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Account head type should not be null' );
		}

		return $response;

	}

	## add or update the account heads
	public function _add_update_accounts__head( ParameterBag $request ) {
		$response = [];

		## if validation rule is voilates
		if ( ! empty( $validation_resposne = $this->validate__accounts__head( $request ) ) ) {
			return $validation_resposne;
		}

		$account_heads = null;

		if ( empty( $request->get( 'ah__rf' ) ) ) {
			## add new account
			$account_heads = new AccountHeads();
		} else {
			## update an account
			try {
				$account_heads = $this->account_heads_repository->find( $request->get( 'ah__rf' ) );
			} catch ( \Exception $exception ) {
			}
		}

		## if still account heads entity not found then create
		if ( ! $account_heads instanceof AccountHeads ) {
			$account_heads = new AccountHeads();
		}


		$account_heads->setAhName( $request->get( 'ah__ne' ) );
		$account_heads->setAhDesc( $request->get( 'ah__DS' ) );
		$account_heads->setAhType( $this->default_function->parse__boolean( $request->get( 'ah__ty' ) ) );

		try {
			$this->entity_manager->persist( $account_heads );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $account_heads->getId() . '_af_d_f_____' . $this->environment->render( 'accounts/account_head_list_view.html.twig', [ 'account_heads_list' => [ $account_heads ] ] );
		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );
		}

		return $response;

	}

	## get the the account head
	public function get__the_account_head_( $reference ) {
		$response = null;
		if ( ! empty( $reference ) ) {
			try {
				$response = $this->account_heads_repository->find( $reference );
			} catch ( \Exception $exception ) {
				$response = $exception->getMessage();
			}
		}

		return $response;
	}

	## get the income head
	public function get_the_income_head(){
		return $this->account_heads_repository->findBy(['ah_type' => true]);
	}

	## get the expense head
	public function get_the_expense_head(){
		return $this->account_heads_repository->findBy(['ah_type' => false]);
	}




	/*
	 * Payment methods
	 *
	 * */

	## validate the payment methods before save data in it.
	public function validate__payment__methods( ParameterBag $request ) {
		$response = [];

		## if payment method name is empty
		if ( empty( $request->get( 'pM_t' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Please type payment method type' );
		}

		## if payment method is not selected as default or not default.
		if ( empty( $request->get( 'pM_iD' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Payment method must be selected as default or not to be default' );
		}


		## if user try to add new record.
		if ( empty( $request->get( 'pM__rf' ) ) ) {
			## if payment method type is already exits..
			$payment__repo_response = $this->payment_methods_repository->findOneBy( [ 'pm_type' => $request->get( 'pM_t' ) ] );
			if ( $payment__repo_response instanceof PaymentMethods ) {
				$response = $this->default_function->push_error( $response, 'Payment method with  ' . $request->get( 'pM_t' ) . ' type is already exits' );
			}

		}

		return $response;
	}

	## add or update the payment methods
	public function _add_update_payment_methods( ParameterBag $request ) {
		$response = [];

		## if validation rule is voilates
		if ( ! empty( $validation_resposne = $this->validate__payment__methods( $request ) ) ) {
			return $validation_resposne;
		}

		$paymentEntity = null;

		if ( empty( $request->get( 'pM__rf' ) ) ) {
			## add new payment methods
			$paymentEntity = new PaymentMethods();
		} else {
			## update payment methods
			try {
				$paymentEntity = $this->payment_methods_repository->find( $request->get( 'pM__rf' ) );
			} catch ( \Exception $exception ) {
			}
		}

		## if still account entity not found then create
		if ( ! $paymentEntity instanceof PaymentMethods ) {
			$paymentEntity = new PaymentMethods();
		}

		if ( $request->get( 'pM_iD' ) == '2' ) {
			## check payment method with the default value is exits or not.
			$paymentMethodResponse = $this->checkDefaultDuplicatePaymentMethod( $paymentEntity->getId() );
			if ( $paymentMethodResponse instanceof PaymentMethods ) {
				$response = $this->default_function->push_error( $response, 'Unable to make it default because - payment method -  ' . $paymentMethodResponse->getPmType() . ' is already selected as a default' );
			}
		}

		## return back if we've an error.
		if ( ! empty( $response ) ) {
			return $response;
		}


		$paymentEntity->setPmType( $request->get( 'pM_t' ) );
		$paymentEntity->setPmIsDefault( $this->default_function->parse__boolean( $request->get( 'pM_iD' ) ) );

		try {
			$this->entity_manager->persist( $paymentEntity );
			$this->entity_manager->flush();
			$response = 'escape__fromErro_' . $paymentEntity->getId() . '_af_d_f_____' . $this->environment->render( 'accounts/payment_methods_list_view.html.twig', [ 'payment_method_list' => [ $paymentEntity ] ] );
		} catch ( \Exception $exception ) {
			$response = $this->default_function->push_error( $response, $exception->getMessage() );
		}

		return $response;

	}

	## get the payment method.
	public function get__the_payment_method( $reference = null, $key = null, $value = null ) {
		$response = null;
		try {
			if ( ! empty( $reference ) ) {
				$response = $this->payment_methods_repository->find( $reference );
			} else if ( ! empty( $key ) && ! empty( $value ) ) {
				$response = $this->payment_methods_repository->findOneBy( [ $key => $value ] );
			}
		} catch ( \Exception $exception ) {
			$response = $exception->getMessage();
		}

		return $response;
	}

	## check duplicate payment default methods.
	public function checkDefaultDuplicatePaymentMethod( int $paymentMethodRef = null ) {


		if ( empty( $paymentMethodRef ) ) {
			$payment__repo_response = $this->payment_methods_repository->findOneBy( [ 'pm_is_default' => true ] );
		} else {
			## make sure other payment method doesn't have a default value.
			$payment__repo_response = $this->payment_methods_repository->findNotOneBy( 'pm_is_default', true, $paymentMethodRef );
			$payment__repo_response = isset( $payment__repo_response[0] ) ? $payment__repo_response[0] : $payment__repo_response;
		}

		return $payment__repo_response;

	}

}