<?php


namespace App\Service\SMSGateways;


use App\Entity\SMSGateways;
use App\Repository\SMSGatewaysRepository;
use App\Service\DefaultFunction;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\ParameterBag as ParameterBagAlias;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

class OperationalionalGatewayClass {

	/**
	 * @var DefaultFunction
	 */
	private $defaultFunction;
	/**
	 * @var EntityManagerInterface
	 */
	private $entityManager;
	/**
	 * @var SMSGatewaysRepository
	 */
	private $SMSGatewaysRepository;

	## ....
	const serviceReference = [
		'CreativeONSMS' => 'CreativeOn',
		'twilioSMS'     => 'Twilio',
	];
	/**
	 * @var CreativeONSMS
	 */
	private $creativeONSMS;

	public function __construct( SMSGatewaysRepository $SMSGatewaysRepository, DefaultFunction $defaultFunction, EntityManagerInterface $entityManager, CreativeONSMS $creativeONSMS ) {
		$this->defaultFunction       = $defaultFunction;
		$this->entityManager         = $entityManager;
		$this->SMSGatewaysRepository = $SMSGatewaysRepository;
		$this->creativeONSMS         = $creativeONSMS;
	}


	/**
	 *  Get gateway from database.
	 *
	 * @param $ref : id of the gateway record
	 *
	 * @param $key
	 * @param $value
	 *
	 * @return SMSGateways|string|null
	 */
	public function getGtw( $ref = null, $key = null, $value = null ) {
		$returnValue = null;

		if ( ! empty( $ref ) ) {
			## find by id
			try {
				$returnValue = $this->SMSGatewaysRepository->find( $ref );
			} catch ( \Exception $exception ) {
				$returnValue = $exception->getMessage();
			}
		} else if ( ! empty( $key ) && ! empty( $value ) ) {
			## find by key value pair
			try {
				$returnValue = $this->SMSGatewaysRepository->findOneBy( [ $key => $value ] );
			} catch ( \Exception $exception ) {
				$returnValue = $exception->getMessage();
			}
		}

		return $returnValue;
	}

	/**
	 * @param ParameterBagAlias $request
	 *
	 * @return array|mixed
	 *
	 */
	public function validateGtw( ParameterBagAlias $request ) {
		$response = [];
		if ( empty( $request->get( 'gtw_name' ) ) ) {
			$response = $this->defaultFunction->push_error( $response, 'SMS Gateway is missing' );
		}

		if ( empty( $request->get( 'gtw_service' ) ) ) {
			$response = $this->defaultFunction->push_error( $response, 'Which service you are using to send messages' );
		}

		return $response;
	}

	/**
	 *
	 * @param ParameterBagAlias $request
	 *
	 * @return array|mixed|string
	 *  PURPOSE : Save SMS Gateway
	 */
	public function saveGtw( ParameterBagAlias $request ) {

		## process validation.
		if ( ! empty( $validationResponse = $this->validateGtw( $request ) ) ) {
			return $validationResponse;
		}

		## get the sms gateway reference
		$SMSGtw = $this->getGtw( $request->get( 'sm_gtw' ) );

		## create new instance if not exits.
		if ( ! $SMSGtw instanceof SMSGateways ) {
			$SMSGtw = new SMSGateways();
			## when some when adding new record validate only 1 sms gateway is enabled.
			if ( $this->getGtw( null, 'sms_gw_is_active', true ) instanceof SMSGateways ) {
				return 'At same time only one Gateway mark as Active.';
			}
		}

		$SMSGtw->setSmsGwName( $request->get( 'gtw_name' ) );
		$SMSGtw->setSmsGwAccountId( $request->get( 'gtw_account' ) );
		$SMSGtw->setSmsGwFrom( $request->get( 'gtw_sms_sent_from', 'Fekara' ) );
		$SMSGtw->setSmsGwAuthorToken( $request->get( 'gtw_authToken' ) );
		$SMSGtw->setSmsGwCustomerId( $request->get( 'gtw_customer' ) );
		$SMSGtw->setSmsGwService( $request->get( 'gtw_service' ) );
		$SMSGtw->setSmsGwHeader( $request->get( 'gtw_header' ) );
		$SMSGtw->setSmsGwFooter( $request->get( 'gtw_footer' ) );
		$SMSGtw->setEndPoint( $request->get( 'gtw_endpoint' ) );
		$SMSGtw->setSmsGwIsActive( $this->defaultFunction->parse__boolean( $request->get( 'smsIsActive' ) ) );

		try {
			$this->entityManager->persist( $SMSGtw );
			$this->entityManager->flush();
			$response = 'OK';
		} catch ( \Exception $exception ) {
			$response = $exception->getMessage();
		}

		return $response;
	}


	/**
	 * PURPOSE: Get Active Gateway from the system and send message to receptionist
	 *
	 * @param ParameterBagAlias $bag
	 *
	 * @return string
	 */
	public function sendMessage( ParameterBagAlias $bag ) {
		return 'Message has stopped to send';
		$SMSGtw = $this->getGtw( null, 'sms_gw_is_active', true );
		if ( ! $SMSGtw instanceof SMSGateways ) {
			## get last record from database.
			$SMSGtw = $this->SMSGatewaysRepository->findBy( [], [ 'id' => 'desc' ], 1, 0 );
		}

		if ( ! $SMSGtw instanceof SMSGateways ) {
			## not SMS service found.
			return 'No SMS Gateway has configured';
		}

		$service = $SMSGtw->getSmsGwService();
		if ( in_array( $service, array_keys( OperationalionalGatewayClass::serviceReference ) ) ) {
			$service = $service . 'Fun';
			if ( method_exists( $this, $service ) ) {
				## extracting receiver and message.
				return $this->$service( $SMSGtw, $bag );
			}
		} else {
			return 'No Such service found';
		}
	}

	public function CreativeONSMSFun( SMSGateways $SMSGateways, ParameterBagAlias $bag ) {
		try {
			return $this->creativeONSMS->sendMessage( $SMSGateways, [
				'receiver' => $bag->get( 'to', null ),
				'message'  => $bag->get( 'message', null ),
			] );
		} catch ( TransportExceptionInterface $e ) {
			return $e->getMessage();
		}
	}


}