<?php


namespace App\Service;


use App\Entity\Guardian;
use App\Entity\Tokens;
use App\Entity\User;
use App\Repository\TokensRepository;
use Doctrine\ORM\EntityManagerInterface;
use http\Encoding\Stream\Inflate;
use Nzo\UrlEncryptorBundle\UrlEncryptor\UrlEncryptor;
use Symfony\Component\HttpFoundation\ParameterBag;

class CustomTokenManager
{


    const  GenerationOcc = [
        ## forgot passowrd
        'forgot_password' => 'fp',
        'apiAuth' => 'apiAuthentication',
    ];
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var TokensRepository
     */
    private $tokens_repository;
    /**
     * @var UrlEncryptor
     */
    private $url_encryptor;

    public function __construct(
        DefaultFunction $default_function,
        EntityManagerInterface $entity_manager,
        TokensRepository $tokens_repository,
        UrlEncryptor $url_encryptor
    ) {
        $this->default_function = $default_function;
        $this->entity_manager = $entity_manager;
        $this->tokens_repository = $tokens_repository;
        $this->url_encryptor = $url_encryptor;
    }

    ## validate token
    public function validate___token(ParameterBag $bag)
    {
        $response = [];

        ## token string
        if (empty($bag->get('tk__'))) {
            $response = $this->default_function->push_error($response, 'Token should not be empty');
        }

        ## for what king this token is generated.
        if (empty($bag->get('gOc')) || empty(self::GenerationOcc[$bag->get('gOc')])) {
            $response = $this->default_function->push_error(
                $response,
                'Purpose of token generation or from where it generate'
            );
        }

        return $response;
    }

    ## get the token
    public function get__token($token = null, $key = null, $value = null)
    {
        $response = null;
        try {

            if (!empty($token)) {
                $response = $this->tokens_repository->findOneBy(['token_name' => $token]);
            } elseif (!empty($key) && !empty($value)) {
                $response = $this->tokens_repository->findOneBy([$key => $value]);
            }

        } catch (\Exception $exception) {
            $response = $exception->getMessage();

        }

        return $response;
    }

    ## save token
    public function save__token(ParameterBag $bag)
    {
        $response = [];
        if ($validation_response = $this->validate___token($bag)) {
            return $validation_response;
        }

        if (empty($bag->get('t__d'))) {
            $Entity = new  Tokens();
        } else {

            if ($bag->get('t__d') instanceof Tokens) {
                $Entity = $bag->get('t__d');
            } else {
                $Entity = $this->get__token($bag->get('t__d'));
                if (!$Entity instanceof Tokens) {
                    $Entity = new Tokens();
                }
            }
        }


        ## save created at
//        $Entity->setCreatedAt($this->default_function->convert_datetimeStringIntoObject(''));
        $Entity->setExpireAt($this->default_function->convert_datetimeStringIntoObject($bag->get('t__ex')));
        $Entity->setGenerationEvent($bag->get('gOc'));
        $Entity->setIsUsed($this->default_function->parse__boolean($bag->get('tIs', 0)));
        $Entity->setTokenName($bag->get('tk__'));

        if ($bag->get('user') instanceof User) {
            $Entity->setUser($bag->get('user'));
        }

        if ($bag->get('guardian') instanceof Guardian) {
            $Entity->setGuardian($bag->get('guardian'));
        }

        try {
            $this->entity_manager->persist($Entity);
            $this->entity_manager->flush();
            $response = 'OK'.$Entity->getTokenName();
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }


        return $response;
    }

    ## encrypt data - generate token
    public function generate_token(string $string)
    {

        ## wrap string
        $string = uniqid().'___'.$string.'___'.uniqid();

        ## url encryption
        $string = $this->url_encryptor->encrypt($string);

        ## encode again
        $string = base64_encode($string);

        return $string;
    }

    ## decrypt token
    public function decrypt__token(string $string)
    {

        ## decode.
        $string = base64_decode($string);

        ## decode
        $string = $this->url_encryptor->decrypt($string);

        ## make array from the string
        $array = explode('___', $string);
        if (is_array($array) && !empty($array[1])) {
            $string = $array[1];
        }

        return $string;
    }

    ## is this toke is valid
    ## $tokenValidationBaseOnTimeOrOneTimeUse = false (mean this is time base token)
    ## $tokenValidationBaseOnTimeOrOneTimeUse = true (mean this is one time token)
    /**
     * @param string $token
     * @param bool $tokenValidationBaseOnTimeOrOneTimeUse
     * @param User|null $user
     * @param Guardian|null $guardian
     * @return bool|string|null
     * @throws \Exception
     */
    public function is__token__valid(
        string $token,
        $tokenValidationBaseOnTimeOrOneTimeUse = false,
        User $user = null,
        Guardian $guardian = null
    ) {

        $searchBag = new ParameterBag();
        $searchBag->set('token', $token);

        if ($user instanceof User) {
            ## user relation
            $searchBag->set('user', $user->getId());
        } elseif ($guardian instanceof Guardian) {
            ## guardian relation
            $searchBag->set('guardian', $guardian->getId());
        }


        $tokens_repo = $this->tokens_repository->search($searchBag);
        ## if toke is exist in database or not.
        if (empty($tokens_repo[0]) || !$tokens_repo[0] instanceof Tokens) {
            return 'ahh, Invalid token';
        } else {
            /** @var Tokens $token_repo */
            $token_repo = $tokens_repo[0];
        }

        $response = null;
        ## validate the token  --- check token expire
        if ($tokenValidationBaseOnTimeOrOneTimeUse) {
            ## one time token use
            $response['message'] = !$token_repo->getIsUsed() ?? 'Token is expire';
            $response['response'] = !$token_repo->getIsUsed() ?? false;
        } else {
            $response = $this->default_function->compare__two_datetime($token_repo->getExpireAt(), new \DateTime());
        }
        return $response;
    }

    ## expire token
    public function expire__OneTimeUsed__token__($token)
    {
        $tokenEntity = $this->get__token($token);
        ## if token is not a entity
        if ($tokenEntity instanceof Tokens) {
            $tokenEntity->setIsUsed(true);
            $tokenEntity->setExpireAt($this->default_function->convert_datetimeStringIntoObject(''));
            $this->entity_manager->persist($tokenEntity);
            $this->entity_manager->flush();

            return 'OK';
        } else {
            return 'Invalid token';
        }
    }

    /**
     * === Manage API Token
     */


    /**
     * === Save or update Api Token
     * @param User $user
     * @param Guardian $guardian
     * @return string
     * @throws \Exception
     */
    public function saveUpdateApiToken(User $user = null, Guardian $guardian = null)
    {

        $bag = new ParameterBag();

        ## if both user and guardian are invalid.
        if (!($user instanceof User) && !($guardian instanceof Guardian)) {
            return 'Must provide valid User or Guardian';
        } elseif ($user instanceof User) {
            ## user relation
            $token = $this->get__token(null, 'user', $user->getId());
            $bag->set('user', $user);
        } elseif ($guardian instanceof Guardian) {
            ## guardian relation
            $token = $this->get__token(null, 'guardian', $guardian->getId());
            $bag->set('guardian', $guardian);
        }

        $bag->set('t__d', $token);
        $bag->set('t__ex', new \DateTime('+5 hours'));
        $bag->set('gOc', 'apiAuth');
        try {
            $secretKey = crypt(random_bytes(200), '$6$rounds=50000$'.getenv('APP_SECRET').'$');
            $bag->set('tk__', $secretKey);
        } catch (\Exception $e) {
            $bag->set('tk__', hash(getenv('APP_SECRET'), getenv('APP_ENV')));
        }

        return $this->save__token($bag);
    }

}