<?php

namespace App\Repository;

use App\Entity\ClassSessionEnrolmentFeeSchedule;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBag;

/**
 * @method ClassSessionEnrolmentFeeSchedule|null find( $id, $lockMode = null, $lockVersion = null )
 * @method ClassSessionEnrolmentFeeSchedule|null findOneBy( array $criteria, array $orderBy = null )
 * @method ClassSessionEnrolmentFeeSchedule[]    findAll()
 * @method ClassSessionEnrolmentFeeSchedule[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 *
 *
 */
class ClassSessionEnrolmentFeeScheduleRepository extends ServiceEntityRepository {

	/**
	 * @var RegistryInterface
	 */
	private $registry;
	/**
	 * @var ClassSessionEnrolmentRepository
	 */
	private $class_session_enrolment_repository;

	public function __construct( RegistryInterface $registry, ClassSessionEnrolmentRepository $class_session_enrolment_repository ) {
		parent::__construct( $registry, ClassSessionEnrolmentFeeSchedule::class );
		$this->registry                           = $registry;
		$this->class_session_enrolment_repository = $class_session_enrolment_repository;
	}


	## getting special fee for the student if exits.
	public function get_special_fee_for_student( $userRef, \Symfony\Component\HttpFoundation\ParameterBag $requirement ) {
		## if user reference is empty
		if ( empty( $userRef ) ) {
			return '';
		}

		$back_response = '';

		## get the class session enrollment.
		$response = $this->class_session_enrolment_repository->get_special_fee_for_student( $userRef, $requirement );
		if ( ! empty( $response ) && is_array( $response ) ) {
			## get only array id's
			$response_ref = array_column( $response, 'id' );
			## convert  array into string.
			$response_ref_string = implode( ',', $response_ref );


			$queryBuilder  = $this->createQueryBuilder( 'class_session_enrolment_fee_schedule' );
			$queryBuilder  = $queryBuilder->add( 'where', $queryBuilder->expr()
			                                                           ->in( 'class_session_enrolment_fee_schedule.class_session_enrolment', $response_ref ) );
			$back_response = $queryBuilder->getQuery()->getResult();

		}

		return $back_response;

	}

}
